/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;

public class AnalyzerOptimizer
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyzerOptimizer.class);
    private final FileSystem fs;
    private final ActiveRules activeRules;

    public AnalyzerOptimizer(FileSystem fs, ActiveRules activeRules) {
        this.fs = fs;
        this.activeRules = activeRules;
    }

    public boolean shouldExecute(DefaultSensorDescriptor descriptor) {
        if (!this.fsCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related file in current project", (Object)descriptor.name());
            return false;
        }
        if (!this.activeRulesCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related rule activated in the quality profile", (Object)descriptor.name());
            return false;
        }
        return true;
    }

    private boolean activeRulesCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.ruleRepositories().isEmpty()) {
            for (String repoKey : descriptor.ruleRepositories()) {
                if (this.activeRules.findByRepository(repoKey).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean fsCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.languages().isEmpty() || !descriptor.types().isEmpty()) {
            FilePredicate langPredicate = descriptor.languages().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().hasLanguages(descriptor.languages());
            FilePredicate typePredicate = descriptor.types().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().none();
            for (InputFile.Type type : descriptor.types()) {
                typePredicate = this.fs.predicates().or(typePredicate, this.fs.predicates().hasType(type));
            }
            return this.fs.hasFiles(this.fs.predicates().and(langPredicate, typePredicate));
        }
        return true;
    }
}

