/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.base.Preconditions;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;
import org.sonar.batch.scan2.DefaultMeasureValueCoder;

public class AnalyzerMeasureCache
implements BatchComponent {
    private final Cache<DefaultMeasure> cache;

    public AnalyzerMeasureCache(Caches caches, MetricFinder metricFinder) {
        caches.registerValueCoder(DefaultMeasure.class, new DefaultMeasureValueCoder(metricFinder));
        this.cache = caches.createCache("measures");
    }

    public Iterable<Cache.Entry<DefaultMeasure>> entries() {
        return this.cache.entries();
    }

    public Iterable<DefaultMeasure> byModule(String projectKey) {
        return this.cache.values(projectKey);
    }

    public DefaultMeasure<?> byMetric(String projectKey, String resourceKey, String metricKey) {
        return this.cache.get(projectKey, resourceKey, metricKey);
    }

    public AnalyzerMeasureCache put(String projectKey, String resourceKey, DefaultMeasure<?> measure) {
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)resourceKey);
        Preconditions.checkNotNull(measure);
        this.cache.put(projectKey, resourceKey, measure.metric().key(), measure);
        return this;
    }

    public boolean contains(String projectKey, String resourceKey, DefaultMeasure<?> measure) {
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)resourceKey);
        Preconditions.checkNotNull(measure);
        return this.cache.containsKey(projectKey, resourceKey, measure.metric().key());
    }

    public Iterable<DefaultMeasure> all() {
        return this.cache.values();
    }
}

