/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.measure;

import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.ValueCoder;
import javax.annotation.Nullable;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.technicaldebt.batch.Characteristic;
import org.sonar.api.technicaldebt.batch.Requirement;
import org.sonar.api.technicaldebt.batch.TechnicalDebtModel;

class MeasureValueCoder
implements ValueCoder {
    private final MetricFinder metricFinder;
    private final TechnicalDebtModel techDebtModel;

    public MeasureValueCoder(MetricFinder metricFinder, TechnicalDebtModel techDebtModel) {
        this.metricFinder = metricFinder;
        this.techDebtModel = techDebtModel;
    }

    public void put(Value value, Object object, CoderContext context) {
        Measure m = (Measure)object;
        value.putUTF(m.getMetricKey());
        value.put((Object)m.getValue());
        this.putUTFOrNull(value, m.getData());
        this.putUTFOrNull(value, m.getDescription());
        value.putString(m.getAlertStatus() != null ? m.getAlertStatus().name() : null);
        this.putUTFOrNull(value, m.getAlertText());
        value.put((Object)m.getTendency());
        value.putDate(m.getDate());
        value.put((Object)m.getVariation1());
        value.put((Object)m.getVariation2());
        value.put((Object)m.getVariation3());
        value.put((Object)m.getVariation4());
        value.put((Object)m.getVariation5());
        this.putUTFOrNull(value, m.getUrl());
        Characteristic characteristic = m.getCharacteristic();
        value.put((Object)(characteristic != null ? characteristic.id() : null));
        Requirement requirement = m.getRequirement();
        value.put((Object)(requirement != null ? requirement.id() : null));
        Integer personId = m.getPersonId();
        value.put(personId != null ? Integer.valueOf(personId) : null);
        PersistenceMode persistenceMode = m.getPersistenceMode();
        value.putString(persistenceMode != null ? persistenceMode.name() : null);
    }

    private void putUTFOrNull(Value value, @Nullable String utfOrNull) {
        if (utfOrNull != null) {
            value.putUTF(utfOrNull);
        } else {
            value.putNull();
        }
    }

    public Object get(Value value, Class clazz, CoderContext context) {
        Measure m = new Measure();
        String metricKey = value.getString();
        Metric metric = this.metricFinder.findByKey(metricKey);
        if (metric == null) {
            throw new IllegalStateException("Unknow metric with key " + metricKey);
        }
        m.setMetric(metric);
        m.setRawValue(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setData(value.getString());
        m.setDescription(value.getString());
        m.setAlertStatus(value.isNull(true) ? null : Metric.Level.valueOf((String)value.getString()));
        m.setAlertText(value.getString());
        m.setTendency(value.isNull(true) ? null : Integer.valueOf(value.getInt()));
        m.setDate(value.getDate());
        m.setVariation1(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setVariation2(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setVariation3(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setVariation4(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setVariation5(value.isNull(true) ? null : Double.valueOf(value.getDouble()));
        m.setUrl(value.getString());
        m.setCharacteristic(value.isNull(true) ? null : this.techDebtModel.characteristicById(Integer.valueOf(value.getInt())));
        m.setRequirement(value.isNull(true) ? null : this.techDebtModel.requirementsById(Integer.valueOf(value.getInt())));
        m.setPersonId(value.isNull(true) ? null : Integer.valueOf(value.getInt()));
        m.setPersistenceMode(value.isNull(true) ? null : PersistenceMode.valueOf((String)value.getString()));
        return m;
    }
}

