/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.measure;

import com.google.common.base.Preconditions;
import org.sonar.api.BatchComponent;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Resource;
import org.sonar.api.technicaldebt.batch.Characteristic;
import org.sonar.api.technicaldebt.batch.TechnicalDebtModel;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;
import org.sonar.batch.scan.measure.MeasureValueCoder;

public class MeasureCache
implements BatchComponent {
    private final Cache<Measure> cache;

    public MeasureCache(Caches caches, MetricFinder metricFinder, TechnicalDebtModel techDebtModel) {
        caches.registerValueCoder(Measure.class, new MeasureValueCoder(metricFinder, techDebtModel));
        this.cache = caches.createCache("measures");
    }

    public Iterable<Cache.Entry<Measure>> entries() {
        return this.cache.entries();
    }

    public Iterable<Measure> byResource(Resource r) {
        return this.cache.values(r.getEffectiveKey());
    }

    public Iterable<Measure> byMetric(Resource r, String metricKey) {
        return this.byMetric(r.getEffectiveKey(), metricKey);
    }

    public Iterable<Measure> byMetric(String resourceKey, String metricKey) {
        return this.cache.values(resourceKey, metricKey);
    }

    public MeasureCache put(Resource resource, Measure measure) {
        Preconditions.checkNotNull((Object)resource.getEffectiveKey());
        Preconditions.checkNotNull((Object)measure.getMetricKey());
        this.cache.put(resource.getEffectiveKey(), measure.getMetricKey(), MeasureCache.computeMeasureKey(measure), measure);
        return this;
    }

    public boolean contains(Resource resource, Measure measure) {
        Preconditions.checkNotNull((Object)resource.getEffectiveKey());
        Preconditions.checkNotNull((Object)measure.getMetricKey());
        return this.cache.containsKey(resource.getEffectiveKey(), measure.getMetricKey(), MeasureCache.computeMeasureKey(measure));
    }

    private static String computeMeasureKey(Measure m) {
        StringBuilder sb = new StringBuilder();
        if (m.getMetricKey() != null) {
            sb.append(m.getMetricKey());
        }
        sb.append("|");
        Characteristic characteristic = m.getCharacteristic();
        if (characteristic != null) {
            sb.append(characteristic.key());
        }
        sb.append("|");
        Integer personId = m.getPersonId();
        if (personId != null) {
            sb.append(personId);
        }
        if (m instanceof RuleMeasure) {
            sb.append("|");
            sb.append(((RuleMeasure)m).ruleKey());
        }
        return sb.toString();
    }
}

