/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.measure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.batch.protocol.input.GlobalReferentials;

public final class DeprecatedMetricFinder
implements MetricFinder {
    private Map<String, Metric> metricsByKey = Maps.newLinkedHashMap();
    private Map<Integer, Metric> metricsById = Maps.newLinkedHashMap();

    public DeprecatedMetricFinder(GlobalReferentials globalReferentials) {
        for (org.sonar.batch.protocol.input.Metric metric : globalReferentials.metrics()) {
            Metric hibernateMetric = new Metric.Builder(metric.key(), metric.name(), Metric.ValueType.valueOf((String)metric.valueType())).create().setDirection(Integer.valueOf(metric.direction())).setQualitative(Boolean.valueOf(metric.isQualitative())).setUserManaged(Boolean.valueOf(metric.isUserManaged())).setDescription(metric.description()).setOptimizedBestValue(Boolean.valueOf(metric.isOptimizedBestValue())).setBestValue(metric.bestValue()).setWorstValue(metric.worstValue()).setId(Integer.valueOf(metric.id()));
            this.metricsByKey.put(metric.key(), hibernateMetric);
            this.metricsById.put(metric.id(), new Metric.Builder(metric.key(), metric.key(), Metric.ValueType.valueOf((String)metric.valueType())).create().setId(Integer.valueOf(metric.id())));
        }
    }

    public Metric findById(int metricId) {
        return this.metricsById.get(metricId);
    }

    public Metric findByKey(String key) {
        return this.metricsByKey.get(key);
    }

    public Collection<Metric> findAll(List<String> metricKeys) {
        LinkedList result = Lists.newLinkedList();
        for (String metricKey : metricKeys) {
            Metric metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    public Collection<Metric> findAll() {
        return this.metricsByKey.values();
    }
}

