/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.measure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.measures.Metric;
import org.sonar.batch.protocol.input.GlobalReferentials;

public class DefaultMetricFinder
implements MetricFinder {
    private Map<String, Metric> metricsByKey = Maps.newLinkedHashMap();

    public DefaultMetricFinder(GlobalReferentials globalReferentials) {
        for (org.sonar.batch.protocol.input.Metric metric : globalReferentials.metrics()) {
            this.metricsByKey.put(metric.key(), (Metric)new Metric.Builder(metric.key(), metric.key(), Metric.ValueType.valueOf((String)metric.valueType())).create());
        }
    }

    public Metric findByKey(String key) {
        return this.metricsByKey.get(key);
    }

    public Collection<Metric> findAll(List<String> metricKeys) {
        LinkedList result = Lists.newLinkedList();
        for (String metricKey : metricKeys) {
            Metric metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    public Collection<Metric> findAll() {
        return this.metricsByKey.values();
    }
}

