/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.BatchComponent;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.core.source.db.SnapshotDataDao;
import org.sonar.core.source.db.SnapshotDataDto;

public class PreviousFileHashLoader
implements BatchComponent {
    private final SnapshotDataDao dao;
    private final PastSnapshotFinder pastSnapshotFinder;
    private final Snapshot snapshot;

    public PreviousFileHashLoader(Snapshot snapshot, SnapshotDataDao dao, PastSnapshotFinder pastSnapshotFinder) {
        this.snapshot = snapshot;
        this.dao = dao;
        this.pastSnapshotFinder = pastSnapshotFinder;
    }

    Map<String, String> hashByRelativePath() {
        Collection selectSnapshotData;
        Map map = Maps.newHashMap();
        PastSnapshot pastSnapshot = this.pastSnapshotFinder.findPreviousAnalysis(this.snapshot);
        if (pastSnapshot.isRelatedToSnapshot() && !(selectSnapshotData = this.dao.selectSnapshotData(pastSnapshot.getProjectSnapshot().getId().longValue(), Arrays.asList("file_hashes"))).isEmpty()) {
            SnapshotDataDto snapshotDataDto = (SnapshotDataDto)selectSnapshotData.iterator().next();
            String data = snapshotDataDto.getData();
            map = KeyValueFormat.parse((String)data);
        }
        return map;
    }
}

