/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.batch.scan.filesystem.InputPathCache;

public class ModuleInputFileCache
extends DefaultFileSystem.Cache
implements BatchComponent {
    private final String moduleKey;
    private final InputPathCache projectCache;

    public ModuleInputFileCache(ProjectDefinition projectDef, InputPathCache projectCache) {
        this.moduleKey = projectDef.getKeyWithBranch();
        this.projectCache = projectCache;
    }

    public Iterable<InputFile> inputFiles() {
        return this.projectCache.filesByModule(this.moduleKey);
    }

    public InputFile inputFile(String relativePath) {
        return this.projectCache.getFile(this.moduleKey, relativePath);
    }

    public InputDir inputDir(String relativePath) {
        return this.projectCache.getDir(this.moduleKey, relativePath);
    }

    protected void doAdd(InputFile inputFile) {
        this.projectCache.put(this.moduleKey, inputFile);
    }

    protected void doAdd(InputDir inputDir) {
        this.projectCache.put(this.moduleKey, inputDir);
    }
}

