/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.TempFolder;

public class ModuleFileSystemInitializer
implements BatchComponent {
    private File baseDir;
    private File workingDir;
    private File buildDir;
    private List<File> sourceDirsOrFiles = Lists.newArrayList();
    private List<File> testDirsOrFiles = Lists.newArrayList();
    private List<File> binaryDirs = Lists.newArrayList();

    public ModuleFileSystemInitializer(ProjectDefinition module, TempFolder tempUtils, PathResolver pathResolver) {
        this.baseDir = module.getBaseDir();
        this.buildDir = module.getBuildDir();
        this.initWorkingDir(module, tempUtils);
        this.initBinaryDirs(module, pathResolver);
        this.initSources(module, pathResolver);
        this.initTests(module, pathResolver);
    }

    private void initWorkingDir(ProjectDefinition module, TempFolder tempUtils) {
        this.workingDir = module.getWorkDir();
        if (this.workingDir == null) {
            this.workingDir = tempUtils.newDir("work");
        } else {
            try {
                FileUtils.forceMkdir((File)this.workingDir);
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to create working dir: " + this.workingDir.getAbsolutePath(), e);
            }
        }
    }

    private void initSources(ProjectDefinition module, PathResolver pathResolver) {
        for (String sourcePath : module.sources()) {
            File dirOrFile = pathResolver.relativeFile(module.getBaseDir(), sourcePath);
            if (!dirOrFile.exists()) continue;
            this.sourceDirsOrFiles.add(dirOrFile);
        }
    }

    private void initTests(ProjectDefinition module, PathResolver pathResolver) {
        for (String testPath : module.tests()) {
            File dirOrFile = pathResolver.relativeFile(module.getBaseDir(), testPath);
            if (!dirOrFile.exists()) continue;
            this.testDirsOrFiles.add(dirOrFile);
        }
    }

    private void initBinaryDirs(ProjectDefinition module, PathResolver pathResolver) {
        for (String path : module.getBinaries()) {
            File dir = pathResolver.relativeFile(module.getBaseDir(), path);
            this.binaryDirs.add(dir);
        }
    }

    File baseDir() {
        return this.baseDir;
    }

    File workingDir() {
        return this.workingDir;
    }

    File buildDir() {
        return this.buildDir;
    }

    List<File> sources() {
        return this.sourceDirsOrFiles;
    }

    List<File> tests() {
        return this.testDirsOrFiles;
    }

    @Deprecated
    List<File> binaryDirs() {
        return this.binaryDirs;
    }
}

