/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import javax.annotation.CheckForNull;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;
import org.sonar.batch.scan.filesystem.DefaultInputFileValueCoder;

public class InputPathCache
implements BatchComponent {
    private static final String DIR = "DIR";
    private static final String FILE = "FILE";
    private final Cache<InputPath> cache;

    public InputPathCache(Caches caches) {
        caches.registerValueCoder(DeprecatedDefaultInputFile.class, new DefaultInputFileValueCoder());
        this.cache = caches.createCache("inputFiles");
    }

    public Iterable<InputPath> all() {
        return this.cache.values();
    }

    public Iterable<InputFile> filesByModule(String moduleKey) {
        return this.cache.values(moduleKey, FILE);
    }

    public Iterable<InputDir> dirsByModule(String moduleKey) {
        return this.cache.values(moduleKey, DIR);
    }

    public InputPathCache removeModule(String moduleKey) {
        this.cache.clear(moduleKey);
        return this;
    }

    public InputPathCache remove(String moduleKey, InputFile inputFile) {
        this.cache.remove(moduleKey, FILE, inputFile.relativePath());
        return this;
    }

    public InputPathCache remove(String moduleKey, InputDir inputDir) {
        this.cache.remove(moduleKey, DIR, inputDir.relativePath());
        return this;
    }

    public InputPathCache put(String moduleKey, InputFile inputFile) {
        this.cache.put(moduleKey, FILE, inputFile.relativePath(), (InputPath)inputFile);
        return this;
    }

    public InputPathCache put(String moduleKey, InputDir inputDir) {
        this.cache.put(moduleKey, DIR, inputDir.relativePath(), (InputPath)inputDir);
        return this;
    }

    @CheckForNull
    public InputFile getFile(String moduleKey, String relativePath) {
        return (InputFile)this.cache.get(moduleKey, FILE, relativePath);
    }

    public InputDir getDir(String moduleKey, String relativePath) {
        return (InputDir)this.cache.get(moduleKey, DIR, relativePath);
    }
}

