/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;

public class FileSystemLogger
implements BatchComponent {
    private final DefaultModuleFileSystem fs;

    public FileSystemLogger(DefaultModuleFileSystem fs) {
        this.fs = fs;
    }

    public void log() {
        this.doLog(LoggerFactory.getLogger(this.getClass()));
    }

    @VisibleForTesting
    void doLog(Logger logger) {
        this.logDir(logger, "Base dir: ", this.fs.baseDir());
        this.logDir(logger, "Working dir: ", this.fs.workDir());
        this.logPaths(logger, "Source paths: ", this.fs.baseDir(), this.fs.sources());
        this.logPaths(logger, "Test paths: ", this.fs.baseDir(), this.fs.tests());
        this.logPaths(logger, "Binary dirs: ", this.fs.baseDir(), this.fs.binaryDirs());
        this.logEncoding(logger, this.fs.encoding());
    }

    private void logEncoding(Logger logger, Charset charset) {
        if (!this.fs.isDefaultJvmEncoding()) {
            logger.info("Source encoding: " + charset.displayName() + ", default locale: " + Locale.getDefault());
        } else {
            logger.warn("Source encoding is platform dependent (" + charset.displayName() + "), default locale: " + Locale.getDefault());
        }
    }

    private void logPaths(Logger logger, String label, File baseDir, List<File> paths) {
        if (!paths.isEmpty()) {
            PathResolver resolver = new PathResolver();
            StringBuilder sb = new StringBuilder(label);
            Iterator<File> it = paths.iterator();
            while (it.hasNext()) {
                File file = it.next();
                String relativePathToBaseDir = resolver.relativePath(baseDir, file);
                if (relativePathToBaseDir == null) {
                    sb.append(file);
                } else if (StringUtils.isBlank((String)relativePathToBaseDir)) {
                    sb.append(".");
                } else {
                    sb.append(relativePathToBaseDir);
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            logger.info(sb.toString());
        }
    }

    private void logDir(Logger logger, String label, File dir) {
        if (dir != null) {
            logger.info(label + dir.getAbsolutePath());
        }
    }
}

