/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.ExclusionFilters;
import org.sonar.batch.scan.filesystem.InputFileBuilder;
import org.sonar.batch.scan.filesystem.InputFileBuilderFactory;
import org.sonar.batch.scan.filesystem.InputPathCache;

public class FileIndexer
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexer.class);
    private static final IOFileFilter DIR_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."))});
    private static final IOFileFilter FILE_FILTER = HiddenFileFilter.VISIBLE;
    private final List<InputFileFilter> filters;
    private final InputPathCache fileCache;
    private final boolean isAggregator;
    private final ExclusionFilters exclusionFilters;
    private final InputFileBuilderFactory inputFileBuilderFactory;

    public FileIndexer(List<InputFileFilter> filters, ExclusionFilters exclusionFilters, InputFileBuilderFactory inputFileBuilderFactory, InputPathCache cache, ProjectDefinition def) {
        this(filters, exclusionFilters, inputFileBuilderFactory, cache, !def.getSubProjects().isEmpty());
    }

    private FileIndexer(List<InputFileFilter> filters, ExclusionFilters exclusionFilters, InputFileBuilderFactory inputFileBuilderFactory, InputPathCache cache, boolean isAggregator) {
        this.filters = filters;
        this.exclusionFilters = exclusionFilters;
        this.inputFileBuilderFactory = inputFileBuilderFactory;
        this.fileCache = cache;
        this.isAggregator = isAggregator;
    }

    void index(DefaultModuleFileSystem fileSystem) {
        if (this.isAggregator) {
            return;
        }
        LOG.info("Index files");
        this.exclusionFilters.prepare();
        Progress progress = new Progress(this.fileCache.filesByModule(fileSystem.moduleKey()), this.fileCache.dirsByModule(fileSystem.moduleKey()));
        InputFileBuilder inputFileBuilder = this.inputFileBuilderFactory.create(fileSystem);
        this.indexFiles(fileSystem, progress, inputFileBuilder, fileSystem.sources(), InputFile.Type.MAIN);
        this.indexFiles(fileSystem, progress, inputFileBuilder, fileSystem.tests(), InputFile.Type.TEST);
        this.indexAllConcurrently(progress);
        for (InputFile indexed : progress.indexed) {
            fileSystem.add(indexed);
        }
        for (InputFile indexed : progress.indexedDir) {
            fileSystem.add((InputDir)indexed);
        }
        for (InputFile removed : progress.removed) {
            this.fileCache.remove(fileSystem.moduleKey(), removed);
        }
        for (InputFile removed : progress.removedDir) {
            this.fileCache.remove(fileSystem.moduleKey(), (InputDir)removed);
        }
        LOG.info(String.format("%d files indexed", progress.count()));
    }

    private void indexAllConcurrently(Progress progress) {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        try {
            List all = executor.invokeAll(progress.indexingTasks);
            for (Future future : all) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("FileIndexer was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Error during file indexing", e);
        }
        executor.shutdown();
    }

    private void indexFiles(DefaultModuleFileSystem fileSystem, Progress progress, InputFileBuilder inputFileBuilder, List<File> sources, InputFile.Type type) {
        for (File dirOrFile : sources) {
            if (dirOrFile.isDirectory()) {
                this.indexDirectory(inputFileBuilder, fileSystem, progress, dirOrFile, type);
                continue;
            }
            this.indexFile(inputFileBuilder, fileSystem, progress, dirOrFile, type);
        }
    }

    private void indexDirectory(InputFileBuilder inputFileBuilder, DefaultModuleFileSystem fileSystem, Progress status, File dirToIndex, InputFile.Type type) {
        Collection files = FileUtils.listFiles((File)dirToIndex, (IOFileFilter)FILE_FILTER, (IOFileFilter)DIR_FILTER);
        for (File file : files) {
            this.indexFile(inputFileBuilder, fileSystem, status, file, type);
        }
    }

    private void indexFile(InputFileBuilder inputFileBuilder, DefaultModuleFileSystem fileSystem, Progress progress, File sourceFile, InputFile.Type type) {
        DeprecatedDefaultInputFile inputFile = inputFileBuilder.create(sourceFile);
        if (inputFile != null && this.exclusionFilters.accept((InputFile)inputFile, type)) {
            this.indexFile(inputFileBuilder, fileSystem, progress, inputFile, type);
        }
    }

    private void indexFile(final InputFileBuilder inputFileBuilder, final DefaultModuleFileSystem fs, final Progress status, final DeprecatedDefaultInputFile inputFile, final InputFile.Type type) {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DeprecatedDefaultInputFile completedFile = inputFileBuilder.complete(inputFile, type);
                if (completedFile != null && FileIndexer.this.accept((InputFile)completedFile)) {
                    status.markAsIndexed((InputFile)inputFile);
                    File parentDir = inputFile.file().getParentFile();
                    String relativePath = new PathResolver().relativePath(fs.baseDir(), parentDir);
                    if (relativePath != null) {
                        DefaultInputDir inputDir = new DefaultInputDir(relativePath);
                        inputDir.setFile(parentDir);
                        inputDir.setKey(fs.moduleKey() + ":" + inputDir.relativePath());
                        status.markAsIndexed((InputDir)inputDir);
                    }
                }
                return null;
            }
        };
        status.planForIndexing(task);
    }

    private boolean accept(InputFile inputFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(inputFile)) continue;
            return false;
        }
        return true;
    }

    private static class Progress {
        private final Set<InputFile> removed;
        private final Set<InputDir> removedDir;
        private final Set<InputFile> indexed;
        private final Set<InputDir> indexedDir;
        private final List<Callable<Void>> indexingTasks;

        Progress(Iterable<InputFile> removed, Iterable<InputDir> removedDir) {
            this.removed = Sets.newHashSet(removed);
            this.removedDir = Sets.newHashSet(removedDir);
            this.indexed = new HashSet<InputFile>();
            this.indexedDir = new HashSet<InputDir>();
            this.indexingTasks = new ArrayList<Callable<Void>>();
        }

        void planForIndexing(Callable<Void> indexingTask) {
            this.indexingTasks.add(indexingTask);
        }

        synchronized void markAsIndexed(InputFile inputFile) {
            if (this.indexed.contains(inputFile)) {
                throw MessageException.of((String)("File " + inputFile + " can't be indexed twice. Please check that inclusion/exclusion patterns produce " + "disjoint sets for main and test files"));
            }
            this.removed.remove(inputFile);
            this.indexed.add(inputFile);
        }

        synchronized void markAsIndexed(InputDir inputDir) {
            this.removedDir.remove(inputDir);
            this.indexedDir.add(inputDir);
        }

        int count() {
            return this.indexed.size();
        }
    }
}

