/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.ValueCoder;
import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;

class DefaultInputFileValueCoder
implements ValueCoder {
    DefaultInputFileValueCoder() {
    }

    public void put(Value value, Object object, CoderContext context) {
        DeprecatedDefaultInputFile f = (DeprecatedDefaultInputFile)object;
        this.putUTFOrNull(value, f.relativePath());
        value.putString(f.getFileBaseDir().toString());
        this.putUTFOrNull(value, f.deprecatedKey());
        value.putString(f.sourceDirAbsolutePath());
        this.putUTFOrNull(value, f.pathRelativeToSourceDir());
        this.putUTFOrNull(value, f.absolutePath());
        value.putString(f.language());
        value.putString(f.type().name());
        value.putString(f.status().name());
        this.putUTFOrNull(value, f.hash());
        value.put(f.lines());
        this.putUTFOrNull(value, f.key());
    }

    private void putUTFOrNull(Value value, @Nullable String utfOrNull) {
        if (utfOrNull != null) {
            value.putUTF(utfOrNull);
        } else {
            value.putNull();
        }
    }

    public Object get(Value value, Class clazz, CoderContext context) {
        DeprecatedDefaultInputFile file = new DeprecatedDefaultInputFile(value.getString());
        file.setBasedir(new File(value.getString()));
        file.setDeprecatedKey(value.getString());
        file.setSourceDirAbsolutePath(value.getString());
        file.setPathRelativeToSourceDir(value.getString());
        file.setAbsolutePath(value.getString());
        file.setLanguage(value.getString());
        file.setType(InputFile.Type.valueOf((String)value.getString()));
        file.setStatus(InputFile.Status.valueOf((String)value.getString()));
        file.setHash(value.getString());
        file.setLines(value.getInt());
        file.setKey(value.getString());
        return file;
    }
}

