/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.ResourceKeyMigration;
import org.sonar.batch.util.DeprecatedKeyUtils;

public class ComponentIndexer
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentIndexer.class);
    private final Languages languages;
    private final Settings settings;
    private final SonarIndex sonarIndex;
    private final ResourceKeyMigration migration;
    private final Project module;

    public ComponentIndexer(Project module, Languages languages, SonarIndex sonarIndex, Settings settings, ResourceKeyMigration migration) {
        this.module = module;
        this.languages = languages;
        this.sonarIndex = sonarIndex;
        this.settings = settings;
        this.migration = migration;
    }

    public void execute(FileSystem fs) {
        this.migration.migrateIfNeeded(this.module, fs);
        boolean shouldImportSource = this.settings.getBoolean("sonar.importSources");
        if (!shouldImportSource) {
            LOG.warn("/!\\ Property 'sonar.importSources' is deprecated. Not importing source will prevent issues to be properly tracked between consecutive analyses.");
        }
        for (InputFile inputFile : fs.inputFiles(fs.predicates().all())) {
            String languageKey = inputFile.language();
            boolean unitTest = InputFile.Type.TEST == inputFile.type();
            String pathFromSourceDir = ((DeprecatedDefaultInputFile)inputFile).pathRelativeToSourceDir();
            if (pathFromSourceDir == null) {
                pathFromSourceDir = inputFile.relativePath();
            }
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.create((String)inputFile.relativePath(), (String)pathFromSourceDir, (Language)this.languages.get(languageKey), (boolean)unitTest);
            if ("java".equals(languageKey)) {
                sonarFile.setDeprecatedKey(DeprecatedKeyUtils.getJavaFileDeprecatedKey(pathFromSourceDir));
            } else {
                sonarFile.setDeprecatedKey(pathFromSourceDir);
            }
            this.sonarIndex.index((Resource)sonarFile);
            this.importSources(fs, shouldImportSource, inputFile, (Resource)sonarFile);
        }
    }

    @VisibleForTesting
    void importSources(FileSystem fs, boolean shouldImportSource, InputFile inputFile, Resource sonarFile) {
        try {
            String source = Files.toString((File)inputFile.file(), (Charset)fs.encoding());
            source = CharMatcher.anyOf((CharSequence)"\ufeff").removeFrom((CharSequence)source);
            if (shouldImportSource) {
                this.sonarIndex.setSource(sonarFile, source);
            }
        }
        catch (Exception e) {
            throw new SonarException("Unable to read and import the source file : '" + inputFile.absolutePath() + "' with the charset : '" + fs.encoding() + "'.", (Throwable)e);
        }
    }
}

