/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.resources.Project;
import org.sonar.batch.scan2.AnalyzerOptimizer;

public class SensorWrapper
implements org.sonar.api.batch.Sensor {
    private Sensor wrappedSensor;
    private SensorContext adaptor;
    private DefaultSensorDescriptor descriptor;
    private AnalyzerOptimizer optimizer;

    public SensorWrapper(Sensor newSensor, SensorContext adaptor, AnalyzerOptimizer optimizer) {
        this.wrappedSensor = newSensor;
        this.optimizer = optimizer;
        this.descriptor = new DefaultSensorDescriptor();
        newSensor.describe((SensorDescriptor)this.descriptor);
        this.adaptor = adaptor;
    }

    public Sensor wrappedSensor() {
        return this.wrappedSensor;
    }

    @DependedUpon
    public List<Metric> provides() {
        return Arrays.asList(this.descriptor.provides());
    }

    @DependsUpon
    public List<Metric> depends() {
        return Arrays.asList(this.descriptor.dependsOn());
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.optimizer.shouldExecute(this.descriptor);
    }

    public void analyse(Project module, org.sonar.api.batch.SensorContext context) {
        this.wrappedSensor.execute(this.adaptor);
    }

    public String toString() {
        return this.descriptor.name() + " (wrapped)";
    }
}

