/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import java.io.Serializable;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.SumChildDistributionFormula;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;
import org.sonar.api.rule.RuleKey;
import org.sonar.batch.duplication.BlockCache;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.scan2.BaseSensorContext;
import org.sonar.core.issue.DefaultIssueBuilder;

public class SensorContextAdaptor
extends BaseSensorContext {
    private final SensorContext sensorContext;
    private final MetricFinder metricFinder;
    private final Project project;
    private final ResourcePerspectives perspectives;

    public SensorContextAdaptor(SensorContext sensorContext, MetricFinder metricFinder, Project project, ResourcePerspectives perspectives, Settings settings, FileSystem fs, ActiveRules activeRules, ComponentDataCache componentDataCache, BlockCache blockCache, DuplicationCache duplicationCache) {
        super(settings, fs, activeRules, componentDataCache, blockCache, duplicationCache);
        this.sensorContext = sensorContext;
        this.metricFinder = metricFinder;
        this.project = project;
        this.perspectives = perspectives;
    }

    public Measure getMeasure(String metricKey) {
        Metric m = this.findMetricOrFail(metricKey);
        return this.getMeasure(m);
    }

    public <G extends Serializable> Measure<G> getMeasure(Metric<G> metric) {
        org.sonar.api.measures.Metric m = (org.sonar.api.measures.Metric)this.findMetricOrFail(metric.key());
        org.sonar.api.measures.Measure measure = this.sensorContext.getMeasure(m);
        if (measure == null) {
            return null;
        }
        return this.measureBuilder().onProject().forMetric(metric).withValue(measure.value()).build();
    }

    public Measure getMeasure(InputFile file, String metricKey) {
        Metric m = this.findMetricOrFail(metricKey);
        return this.getMeasure(file, m);
    }

    private Metric findMetricOrFail(String metricKey) {
        org.sonar.api.measures.Metric m = this.metricFinder.findByKey(metricKey);
        if (m == null) {
            throw new IllegalStateException("Unknow metric with key: " + metricKey);
        }
        return m;
    }

    public <G extends Serializable> Measure<G> getMeasure(InputFile file, Metric<G> metric) {
        org.sonar.api.measures.Metric m;
        File fileRes = File.create((String)file.relativePath());
        org.sonar.api.measures.Measure measure = this.sensorContext.getMeasure((Resource)fileRes, m = (org.sonar.api.measures.Metric)this.findMetricOrFail(metric.key()));
        if (measure == null) {
            return null;
        }
        return this.measureBuilder().onFile(file).forMetric(metric).withValue(measure.value()).build();
    }

    public void addMeasure(Measure<?> measure) {
        org.sonar.api.measures.Metric m = this.metricFinder.findByKey(measure.metric().key());
        if (m == null) {
            throw new IllegalStateException("Unknow metric with key: " + measure.metric().key());
        }
        org.sonar.api.measures.Measure measureToSave = new org.sonar.api.measures.Measure(m);
        this.setValueAccordingToMetricType(measure, m, measureToSave);
        if (measure.inputFile() != null) {
            Formula formula;
            Formula formula2 = formula = measure.metric() instanceof org.sonar.api.measures.Metric ? ((org.sonar.api.measures.Metric)measure.metric()).getFormula() : null;
            if (formula instanceof SumChildDistributionFormula && !Scopes.isHigherThanOrEquals((String)"FIL", (String)((SumChildDistributionFormula)formula).getMinimumScopeToPersist())) {
                measureToSave.setPersistenceMode(PersistenceMode.MEMORY);
            }
            this.sensorContext.saveMeasure(measure.inputFile(), measureToSave);
        } else {
            this.sensorContext.saveMeasure(measureToSave);
        }
    }

    private void setValueAccordingToMetricType(Measure<?> measure, org.sonar.api.measures.Metric<?> m, org.sonar.api.measures.Measure measureToSave) {
        switch (m.getType()) {
            case BOOL: {
                measureToSave.setValue(Double.valueOf(Boolean.TRUE.equals(measure.value()) ? 1.0 : 0.0));
                break;
            }
            case INT: 
            case MILLISEC: {
                measureToSave.setValue(Double.valueOf(((Integer)measure.value()).intValue()));
                break;
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                measureToSave.setValue((Double)measure.value());
                break;
            }
            case STRING: 
            case LEVEL: 
            case DATA: 
            case DISTRIB: {
                measureToSave.setData((String)((Object)measure.value()));
                break;
            }
            case WORK_DUR: {
                measureToSave.setValue(Double.valueOf(((Long)measure.value()).longValue()));
                break;
            }
            default: {
                if (m.isNumericType()) {
                    measureToSave.setValue((Double)measure.value());
                    break;
                }
                if (m.isDataType()) {
                    measureToSave.setData((String)((Object)measure.value()));
                    break;
                }
                throw new UnsupportedOperationException("Unsupported type :" + m.getType());
            }
        }
    }

    public boolean addIssue(Issue issue) {
        InputPath inputPath = issue.inputPath();
        Object r = inputPath != null ? (inputPath instanceof InputDir ? Directory.create((String)inputPath.relativePath()) : File.create((String)inputPath.relativePath())) : this.project;
        Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, (Resource)r);
        if (issuable == null) {
            return false;
        }
        return issuable.addIssue((org.sonar.api.issue.Issue)SensorContextAdaptor.toDefaultIssue(this.project.getKey(), r.getKey(), issue));
    }

    public static DefaultIssue toDefaultIssue(String projectKey, String componentKey, Issue issue) {
        return new DefaultIssueBuilder().componentKey(componentKey).projectKey(projectKey).ruleKey(RuleKey.of((String)issue.ruleKey().repository(), (String)issue.ruleKey().rule())).effortToFix(issue.effortToFix()).line(issue.line()).message(issue.message()).severity(issue.severity()).build();
    }
}

