/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.batch.DefaultProjectTree;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.bootstrap.TaskContainer;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.scan.DefaultSensorMatcher;
import org.sonar.batch.scan.ProjectExclusions;
import org.sonar.batch.scan.ProjectReactorReady;
import org.sonar.batch.scan.ProjectReactorValidator;
import org.sonar.batch.scan.ProjectScanContainer;

public class ScanTask
implements Task {
    public static final TaskDefinition DEFINITION = TaskDefinition.builder().description("Scan project").key("scan").taskClass(ScanTask.class).build();
    private final ComponentContainer taskContainer;

    public ScanTask(TaskContainer taskContainer) {
        this.taskContainer = taskContainer;
    }

    public void execute() {
        boolean sensorMode = "sensor".equals(((BootstrapProperties)this.taskContainer.getComponentByType(BootstrapProperties.class)).property("sonar.analysis.mode"));
        if (sensorMode) {
            new org.sonar.batch.scan2.ProjectScanContainer(this.taskContainer).execute();
        } else {
            this.scan(new ProjectScanContainer(this.taskContainer));
        }
    }

    void scan(ComponentContainer scanContainer) {
        scanContainer.add(new Object[]{new Phases().enable(Phases.Phase.values()), DefaultProjectTree.class, ProjectExclusions.class, ProjectReactorValidator.class, ProjectReactorReady.class, DefaultSensorMatcher.class});
        scanContainer.execute();
    }
}

