/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.GlobalSettings;
import org.sonar.batch.protocol.input.ProjectReferentials;

public class ProjectSettings
extends Settings {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectSettings.class);
    private Configuration deprecatedConfiguration;
    private final GlobalSettings globalSettings;
    private final ProjectReferentials projectReferentials;
    private final AnalysisMode mode;

    public ProjectSettings(ProjectReactor reactor, GlobalSettings globalSettings, PropertyDefinitions propertyDefinitions, ProjectReferentials projectReferentials, Configuration deprecatedConfiguration, AnalysisMode mode) {
        super(propertyDefinitions);
        this.mode = mode;
        this.getEncryption().setPathToSecretKey(globalSettings.getString("sonar.secretKeyPath"));
        this.globalSettings = globalSettings;
        this.projectReferentials = projectReferentials;
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init(reactor);
    }

    private void init(ProjectReactor reactor) {
        LOG.info("Load project settings");
        this.addProperties(this.globalSettings.getProperties());
        this.addProperties(this.projectReferentials.settings(reactor.getRoot().getKeyWithBranch()));
        this.addProperties(reactor.getRoot().getProperties());
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.mode.isPreview() && key.endsWith(".secured") && !key.contains(".license")) {
            throw MessageException.of((String)("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode."));
        }
    }
}

