/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.SonarException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.ResourceDto;

public class ProjectReactorValidator {
    private static final String SONAR_PHASE = "sonar.phase";
    private final Settings settings;
    private final ResourceDao resourceDao;

    public ProjectReactorValidator(Settings settings, ResourceDao resourceDao) {
        this.settings = settings;
        this.resourceDao = resourceDao;
    }

    public void validate(ProjectReactor reactor) {
        this.preventAutomaticProjectCreationIfNeeded(reactor);
        String branch = this.settings.getString("sonar.branch");
        String rootProjectKey = ComponentKeys.createKey((String)reactor.getRoot().getKey(), (String)branch);
        ArrayList<String> validationMessages = new ArrayList<String>();
        this.checkDeprecatedProperties(validationMessages);
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            this.validateModule(moduleDef, validationMessages, branch, rootProjectKey);
        }
        this.validateBranch(validationMessages, branch);
        if (!validationMessages.isEmpty()) {
            throw new SonarException("Validation of project reactor failed:\n  o " + Joiner.on((String)"\n  o ").join(validationMessages));
        }
    }

    private void preventAutomaticProjectCreationIfNeeded(ProjectReactor reactor) {
        String projectKey;
        if (this.settings.getBoolean("sonar.preventAutoProjectCreation") && this.resourceDao.findByKey(projectKey = reactor.getRoot().getKeyWithBranch()) == null) {
            throw new SonarException(String.format("Unable to scan non-existing project \"%s\"", projectKey));
        }
    }

    private void validateModule(ProjectDefinition moduleDef, List<String> validationMessages, @Nullable String branch, String rootProjectKey) {
        if (!ComponentKeys.isValidModuleKey((String)moduleDef.getKey())) {
            validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", moduleDef.getKey()));
        } else if (this.isSubProject(moduleDef)) {
            String moduleKey = ComponentKeys.createKey((String)moduleDef.getKey(), (String)branch);
            ResourceDto rootInDB = this.resourceDao.getRootProjectByComponentKey(moduleKey);
            if (rootInDB == null || "LIB".equals(rootInDB.getQualifier())) {
                return;
            }
            if (rootInDB.getKey().equals(moduleKey)) {
                throw new SonarException(String.format("The project '%s' is already defined in SonarQube but not as a module of project '%s'. If you really want to stop directly analysing project '%s', please first delete it from SonarQube and then relaunch the analysis of project '%s'.", moduleKey, rootProjectKey, moduleKey, rootProjectKey));
            }
            if (!rootProjectKey.equals(rootInDB.getKey())) {
                throw new SonarException(String.format("Module \"%s\" is already part of project \"%s\"", moduleDef.getKey(), rootInDB.getKey()));
            }
        }
    }

    private void checkDeprecatedProperties(List<String> validationMessages) {
        if (this.settings.getString(SONAR_PHASE) != null) {
            validationMessages.add(String.format("Property \"%s\" is deprecated. Please remove it from your configuration.", SONAR_PHASE));
        }
    }

    private boolean isSubProject(ProjectDefinition moduleDef) {
        return moduleDef.getParent() != null;
    }

    private void validateBranch(List<String> validationMessages, @Nullable String branch) {
        if (StringUtils.isNotEmpty((String)branch) && !ComponentKeys.isValidBranch((String)branch)) {
            validationMessages.add(String.format("\"%s\" is not a valid branch name. Allowed characters are alphanumeric, '-', '_' and '.'.", branch));
        }
    }
}

