/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.GlobalSettings;
import org.sonar.batch.protocol.input.ProjectReferentials;

public class ModuleSettings
extends Settings {
    private final Configuration deprecatedCommonsConf;
    private final ProjectReferentials projectReferentials;
    private AnalysisMode analysisMode;

    public ModuleSettings(GlobalSettings batchSettings, ProjectDefinition project, Configuration deprecatedCommonsConf, ProjectReferentials projectReferentials, AnalysisMode analysisMode) {
        super(batchSettings.getDefinitions());
        this.projectReferentials = projectReferentials;
        this.analysisMode = analysisMode;
        this.getEncryption().setPathToSecretKey(batchSettings.getString("sonar.secretKeyPath"));
        LoggerFactory.getLogger(ModuleSettings.class).info("Load module settings");
        this.deprecatedCommonsConf = deprecatedCommonsConf;
        this.init(project, batchSettings);
    }

    private ModuleSettings init(ProjectDefinition project, GlobalSettings batchSettings) {
        this.addProjectProperties(project, batchSettings);
        this.addBuildProperties(project);
        return this;
    }

    private void addProjectProperties(ProjectDefinition project, GlobalSettings batchSettings) {
        this.addProperties(batchSettings.getProperties());
        this.addProperties(this.projectReferentials.settings(project.getKeyWithBranch()));
    }

    private void addBuildProperties(ProjectDefinition project) {
        List<ProjectDefinition> orderedProjects = ModuleSettings.getTopDownParentProjects(project);
        for (ProjectDefinition p : orderedProjects) {
            this.addProperties(p.getProperties());
        }
    }

    static List<ProjectDefinition> getTopDownParentProjects(ProjectDefinition project) {
        ArrayList result = Lists.newArrayList();
        for (ProjectDefinition p = project; p != null; p = p.getParent()) {
            result.add(0, p);
        }
        return result;
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedCommonsConf.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedCommonsConf.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedCommonsConf.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.analysisMode.isPreview() && key.endsWith(".secured") && !key.contains(".license")) {
            throw MessageException.of((String)("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode."));
        }
    }
}

