/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.core.source.db.SnapshotSourceDao;

public class LastSnapshots
implements BatchComponent {
    private final AnalysisMode analysisMode;
    private final ServerClient server;
    private final SnapshotSourceDao sourceDao;

    public LastSnapshots(AnalysisMode analysisMode, SnapshotSourceDao dao, ServerClient server) {
        this.analysisMode = analysisMode;
        this.sourceDao = dao;
        this.server = server;
    }

    @CheckForNull
    public String getSource(Resource resource) {
        String source = null;
        if (ResourceUtils.isFile((Resource)resource)) {
            source = this.analysisMode.isPreview() ? this.loadSourceFromWs(resource) : this.loadSourceFromDb(resource);
        }
        return StringUtils.defaultString(source, (String)"");
    }

    @CheckForNull
    private String loadSourceFromWs(Resource resource) {
        try {
            return this.server.request("/api/sources?resource=" + ServerClient.encodeForUrl(resource.getEffectiveKey()) + "&format=txt", false, this.analysisMode.getPreviewReadTimeoutSec() * 1000);
        }
        catch (HttpDownloader.HttpException he) {
            if (he.getResponseCode() == 404) {
                return "";
            }
            throw he;
        }
    }

    @CheckForNull
    private String loadSourceFromDb(Resource resource) {
        return this.sourceDao.selectSnapshotSourceByComponentKey(resource.getEffectiveKey());
    }
}

