/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRules;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.batch.rule.ModuleQProfiles;
import org.sonar.batch.rule.QProfile;
import org.sonar.batch.rule.RulesProfileWrapper;

public class RulesProfileProvider
extends ProviderAdapter {
    private RulesProfile singleton = null;

    public RulesProfile provide(ModuleQProfiles qProfiles, ActiveRules activeRules, RuleFinder ruleFinder, Settings settings) {
        if (this.singleton == null) {
            String lang = settings.getString("sonar.language");
            this.singleton = StringUtils.isNotBlank((String)lang) ? this.loadSingleLanguageProfile(qProfiles, activeRules, ruleFinder, lang) : this.loadProfiles(qProfiles, activeRules, ruleFinder);
        }
        return this.singleton;
    }

    private RulesProfile loadSingleLanguageProfile(ModuleQProfiles qProfiles, ActiveRules activeRules, RuleFinder ruleFinder, String language) {
        QProfile qProfile = qProfiles.findByLanguage(language);
        if (qProfile != null) {
            return new RulesProfileWrapper(this.select(qProfile, activeRules, ruleFinder));
        }
        return new RulesProfileWrapper(Lists.newArrayList());
    }

    private RulesProfile loadProfiles(ModuleQProfiles qProfiles, ActiveRules activeRules, RuleFinder ruleFinder) {
        ArrayList dtos = Lists.newArrayList();
        for (QProfile qProfile : qProfiles.findAll()) {
            dtos.add(this.select(qProfile, activeRules, ruleFinder));
        }
        return new RulesProfileWrapper(dtos);
    }

    private RulesProfile select(QProfile qProfile, ActiveRules activeRules, RuleFinder ruleFinder) {
        RulesProfile deprecatedProfile = new RulesProfile();
        deprecatedProfile.setName(qProfile.getName());
        deprecatedProfile.setLanguage(qProfile.getLanguage());
        for (ActiveRule activeRule : ((DefaultActiveRules)activeRules).findByLanguage(qProfile.getLanguage())) {
            Rule rule = ruleFinder.findByKey(activeRule.ruleKey());
            org.sonar.api.rules.ActiveRule deprecatedActiveRule = deprecatedProfile.activateRule(rule, RulePriority.valueOf((String)activeRule.severity()));
            for (Map.Entry param : activeRule.params().entrySet()) {
                deprecatedActiveRule.setParameter((String)param.getKey(), (String)param.getValue());
            }
        }
        return deprecatedProfile;
    }
}

