/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.batch.rule.ModuleQProfiles;
import org.sonar.batch.rule.QProfile;
import org.sonar.batch.rule.UsedQProfiles;

public class QProfileSensor
implements Sensor {
    private final ModuleQProfiles moduleQProfiles;
    private final FileSystem fs;

    public QProfileSensor(ModuleQProfiles moduleQProfiles, FileSystem fs) {
        this.moduleQProfiles = moduleQProfiles;
        this.fs = fs;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getModules().isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        UsedQProfiles used = new UsedQProfiles();
        for (String language : this.fs.languages()) {
            QProfile profile = this.moduleQProfiles.findByLanguage(language);
            if (profile == null) continue;
            used.add(profile);
        }
        Measure detailsMeasure = new Measure(CoreMetrics.QUALITY_PROFILES, used.toJson());
        context.saveMeasure(detailsMeasure);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

