/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Qualifiers;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.rule.QProfile;
import org.sonar.batch.rule.UsedQProfiles;
import org.sonar.core.UtcDateUtils;

public class QProfileEventsDecorator
implements Decorator {
    private final TimeMachine timeMachine;
    private final Languages languages;
    private final PersistenceManager persistenceManager;

    public QProfileEventsDecorator(TimeMachine timeMachine, Languages languages, PersistenceManager pm) {
        this.timeMachine = timeMachine;
        this.languages = languages;
        this.persistenceManager = pm;
    }

    @DependsUpon
    public Metric dependsUpon() {
        return CoreMetrics.QUALITY_PROFILES;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!Qualifiers.isProject((Resource)resource, (boolean)true)) {
            return;
        }
        Measure previousMeasure = this.getPreviousMeasure(resource, CoreMetrics.QUALITY_PROFILES);
        if (previousMeasure == null || previousMeasure.getData() == null) {
            return;
        }
        Map<String, QProfile> previousProfiles = UsedQProfiles.fromJson(previousMeasure.getData()).profilesByKey();
        Measure currentMeasure = context.getMeasure(CoreMetrics.QUALITY_PROFILES);
        Map<String, QProfile> currentProfiles = UsedQProfiles.fromJson(currentMeasure.getData()).profilesByKey();
        this.detectNewOrUpdatedProfiles(context, previousProfiles, currentProfiles);
        this.detectNoMoreUsedProfiles(context, previousProfiles, currentProfiles);
    }

    private void detectNoMoreUsedProfiles(DecoratorContext context, Map<String, QProfile> previousProfiles, Map<String, QProfile> currentProfiles) {
        for (QProfile previousProfile : previousProfiles.values()) {
            if (currentProfiles.containsKey(previousProfile.getKey())) continue;
            this.markAsRemoved(context, previousProfile);
        }
    }

    private void detectNewOrUpdatedProfiles(DecoratorContext context, Map<String, QProfile> previousProfiles, Map<String, QProfile> currentProfiles) {
        for (QProfile profile : currentProfiles.values()) {
            QProfile previousProfile = previousProfiles.get(profile.getKey());
            if (previousProfile != null) {
                if (!profile.getRulesUpdatedAt().after(previousProfile.getRulesUpdatedAt())) continue;
                this.markAsChanged(context, previousProfile, profile);
                continue;
            }
            this.markAsAdded(context, profile);
        }
    }

    private void markAsChanged(DecoratorContext context, QProfile previousProfile, QProfile profile) {
        Event event = new Event();
        event.setName(String.format("Changes in %s", this.profileLabel(profile)));
        event.setCategory("Profile");
        Date from = previousProfile.getRulesUpdatedAt();
        String data = KeyValueFormat.format((Map)ImmutableSortedMap.of((Comparable)((Object)"key"), (Object)profile.getKey(), (Comparable)((Object)"from"), (Object)UtcDateUtils.formatDateTime((Date)this.fixDate(from)), (Comparable)((Object)"to"), (Object)UtcDateUtils.formatDateTime((Date)this.fixDate(profile.getRulesUpdatedAt()))));
        event.setData(data);
        this.persistenceManager.saveEvent(context.getResource(), event);
    }

    private Date fixDate(Date date) {
        return DateUtils.addSeconds((Date)date, (int)1);
    }

    private void markAsRemoved(DecoratorContext context, QProfile profile) {
        context.createEvent(String.format("Stop using %s", this.profileLabel(profile)), null, "Profile", null);
    }

    private void markAsAdded(DecoratorContext context, QProfile profile) {
        context.createEvent(String.format("Use %s", this.profileLabel(profile)), null, "Profile", null);
    }

    @CheckForNull
    private Measure getPreviousMeasure(Resource project, Metric metric) {
        TimeMachineQuery query = new TimeMachineQuery(project).setOnlyLastAnalysis(true).setMetrics(new Metric[]{metric});
        List measures = this.timeMachine.getMeasures(query);
        if (measures.isEmpty()) {
            return null;
        }
        return (Measure)measures.get(0);
    }

    private String profileLabel(QProfile profile) {
        Language language = this.languages.get(profile.getLanguage());
        String languageName = language != null ? language.getName() : profile.getLanguage();
        return String.format("'%s' (%s)", profile.getName(), languageName);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

