/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.rule.UsedQProfiles;

public class QProfileDecorator
implements Decorator {
    @DependedUpon
    public Metric provides() {
        return CoreMetrics.QUALITY_PROFILES;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !project.getModules().isEmpty();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!ResourceUtils.isProject((Resource)resource)) {
            return;
        }
        UsedQProfiles used = new UsedQProfiles();
        for (Measure childProfilesMeasure : context.getChildrenMeasures(CoreMetrics.QUALITY_PROFILES)) {
            String data = childProfilesMeasure.getData();
            if (data == null) continue;
            UsedQProfiles childProfiles = UsedQProfiles.fromJson(data);
            used.add(childProfiles);
        }
        Measure detailsMeasure = new Measure(CoreMetrics.QUALITY_PROFILES, used.toJson());
        context.saveMeasure(detailsMeasure);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

