/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;
import org.sonar.batch.protocol.input.ActiveRule;
import org.sonar.batch.protocol.input.ProjectReferentials;

public class ActiveRulesProvider
extends ProviderAdapter {
    private ActiveRules singleton = null;

    public ActiveRules provide(ProjectReferentials ref) {
        if (this.singleton == null) {
            this.singleton = this.load(ref);
        }
        return this.singleton;
    }

    private ActiveRules load(ProjectReferentials ref) {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        for (ActiveRule activeRule : ref.activeRules()) {
            NewActiveRule newActiveRule = builder.create(RuleKey.of((String)activeRule.repositoryKey(), (String)activeRule.ruleKey()));
            newActiveRule.setName(activeRule.name());
            newActiveRule.setSeverity(activeRule.severity());
            newActiveRule.setLanguage(activeRule.language());
            newActiveRule.setInternalKey(activeRule.internalKey());
            newActiveRule.setTemplateRuleKey(activeRule.templateRuleKey());
            for (Map.Entry param : activeRule.params().entrySet()) {
                newActiveRule.setParam((String)param.getKey(), (String)param.getValue());
            }
            newActiveRule.activate();
        }
        return builder.build();
    }
}

