/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.referential;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.TaskProperties;
import org.sonar.batch.protocol.input.ProjectReferentials;
import org.sonar.batch.referential.ProjectReferentialsLoader;

public class DefaultProjectReferentialsLoader
implements ProjectReferentialsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectReferentialsLoader.class);
    private static final String BATCH_PROJECT_URL = "/batch/project";
    private final ServerClient serverClient;
    private final AnalysisMode analysisMode;

    public DefaultProjectReferentialsLoader(ServerClient serverClient, AnalysisMode analysisMode) {
        this.serverClient = serverClient;
        this.analysisMode = analysisMode;
    }

    @Override
    public ProjectReferentials load(ProjectReactor reactor, TaskProperties taskProperties) {
        String url = "/batch/project?key=" + reactor.getRoot().getKeyWithBranch();
        if (taskProperties.properties().containsKey("sonar.profile")) {
            LOG.warn("Ability to set quality profile from command line using 'sonar.profile' is deprecated and will be dropped in a future SonarQube version. Please configure quality profile used by your project on SonarQube server.");
            url = url + "&profile=" + ServerClient.encodeForUrl(taskProperties.properties().get("sonar.profile"));
        }
        url = url + "&preview=" + this.analysisMode.isPreview();
        return ProjectReferentials.fromJson((String)this.serverClient.request(url));
    }
}

