/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.events.DecoratorExecutionHandler;
import org.sonar.api.batch.events.DecoratorsPhaseHandler;
import org.sonar.api.batch.events.InitializerExecutionHandler;
import org.sonar.api.batch.events.InitializersPhaseHandler;
import org.sonar.api.batch.events.MavenPhaseHandler;
import org.sonar.api.batch.events.PostJobExecutionHandler;
import org.sonar.api.batch.events.PostJobsPhaseHandler;
import org.sonar.api.batch.events.ProjectAnalysisHandler;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.TimeUtils;
import org.sonar.batch.events.BatchStepHandler;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.event.PersisterExecutionHandler;
import org.sonar.batch.phases.event.PersistersPhaseHandler;
import org.sonar.batch.profiling.AbstractTimeProfiling;
import org.sonar.batch.profiling.ModuleProfiling;
import org.sonar.batch.profiling.PhaseProfiling;

public class PhasesSumUpTimeProfiler
implements ProjectAnalysisHandler,
SensorExecutionHandler,
DecoratorExecutionHandler,
PostJobExecutionHandler,
DecoratorsPhaseHandler,
SensorsPhaseHandler,
PostJobsPhaseHandler,
MavenPhaseHandler,
InitializersPhaseHandler,
InitializerExecutionHandler,
BatchStepHandler,
PersistersPhaseHandler,
PersisterExecutionHandler {
    static final Logger LOG = LoggerFactory.getLogger(PhasesSumUpTimeProfiler.class);
    private static final int TEXT_RIGHT_PAD = 60;
    private static final int TIME_LEFT_PAD = 10;
    @VisibleForTesting
    ModuleProfiling currentModuleProfiling;
    @VisibleForTesting
    ModuleProfiling totalProfiling;
    private Map<Project, ModuleProfiling> modulesProfilings = new HashMap<Project, ModuleProfiling>();
    private DecoratorsProfiler decoratorsProfiler;
    private final System2 system;

    static void println(String msg) {
        LOG.info(msg);
    }

    static void println(String text, @Nullable Double percent, AbstractTimeProfiling phaseProfiling) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.rightPad((String)text, (int)60)).append(StringUtils.leftPad((String)phaseProfiling.totalTimeAsString(), (int)10));
        if (percent != null) {
            sb.append(" (").append((int)((double)phaseProfiling.totalTime() / percent)).append("%)");
        }
        PhasesSumUpTimeProfiler.println(sb.toString());
    }

    public PhasesSumUpTimeProfiler(System2 system) {
        this.totalProfiling = new ModuleProfiling(null, system);
        this.system = system;
    }

    public void onProjectAnalysis(ProjectAnalysisHandler.ProjectAnalysisEvent event) {
        Project module = event.getProject();
        if (event.isStart()) {
            this.decoratorsProfiler = new DecoratorsProfiler();
            this.currentModuleProfiling = new ModuleProfiling(module, this.system);
        } else {
            this.currentModuleProfiling.stop();
            this.modulesProfilings.put(module, this.currentModuleProfiling);
            long moduleTotalTime = this.currentModuleProfiling.totalTime();
            PhasesSumUpTimeProfiler.println("");
            PhasesSumUpTimeProfiler.println(" -------- Profiling of module " + module.getName() + ": " + TimeUtils.formatDuration((long)moduleTotalTime) + " --------");
            PhasesSumUpTimeProfiler.println("");
            this.currentModuleProfiling.dump();
            PhasesSumUpTimeProfiler.println("");
            PhasesSumUpTimeProfiler.println(" -------- End of profiling of module " + module.getName() + " --------");
            PhasesSumUpTimeProfiler.println("");
            this.totalProfiling.merge(this.currentModuleProfiling);
            if (module.isRoot() && !module.getModules().isEmpty()) {
                this.dumpTotalExecutionSummary();
            }
        }
    }

    private void dumpTotalExecutionSummary() {
        this.totalProfiling.stop();
        long totalTime = this.totalProfiling.totalTime();
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" ======== Profiling of total execution: " + TimeUtils.formatDuration((long)totalTime) + " ========");
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" * Module execution time breakdown: ");
        double percent = (double)totalTime / 100.0;
        for (ModuleProfiling modulesProfiling : AbstractTimeProfiling.truncate(AbstractTimeProfiling.sortByDescendingTotalTime(this.modulesProfilings).values())) {
            PhasesSumUpTimeProfiler.println("   o " + modulesProfiling.moduleName() + " execution time: ", percent, modulesProfiling);
        }
        PhasesSumUpTimeProfiler.println("");
        this.totalProfiling.dump();
        PhasesSumUpTimeProfiler.println("");
        PhasesSumUpTimeProfiler.println(" ======== End of profiling of total execution ========");
        PhasesSumUpTimeProfiler.println("");
    }

    public void onSensorsPhase(SensorsPhaseHandler.SensorsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.SENSOR);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.SENSOR).stop();
        }
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.SENSOR);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getSensor());
        } else {
            profiling.getProfilingPerItem(event.getSensor()).stop();
        }
    }

    @Override
    public void onPersistersPhase(PersistersPhaseHandler.PersistersPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.PERSISTER);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.PERSISTER).stop();
        }
    }

    @Override
    public void onPersisterExecution(PersisterExecutionHandler.PersisterExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.PERSISTER);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getPersister());
        } else {
            profiling.getProfilingPerItem(event.getPersister()).stop();
        }
    }

    public void onDecoratorExecution(DecoratorExecutionHandler.DecoratorExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR);
        if (event.isStart()) {
            if (profiling.getProfilingPerItem(event.getDecorator()) == null) {
                profiling.newItemProfiling(event.getDecorator());
            }
            this.decoratorsProfiler.start(event.getDecorator());
        } else {
            this.decoratorsProfiler.stop();
        }
    }

    public void onDecoratorsPhase(DecoratorsPhaseHandler.DecoratorsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.DECORATOR);
        } else {
            for (Decorator decorator : this.decoratorsProfiler.getDurations().keySet()) {
                this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR).getProfilingPerItem(decorator).setTotalTime(this.decoratorsProfiler.getDurations().get(decorator));
            }
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.DECORATOR).stop();
        }
    }

    public void onPostJobsPhase(PostJobsPhaseHandler.PostJobsPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.POSTJOB);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.POSTJOB).stop();
        }
    }

    public void onPostJobExecution(PostJobExecutionHandler.PostJobExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.POSTJOB);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getPostJob());
        } else {
            profiling.getProfilingPerItem(event.getPostJob()).stop();
        }
    }

    public void onMavenPhase(MavenPhaseHandler.MavenPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.MAVEN);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.MAVEN).stop();
        }
    }

    public void onInitializersPhase(InitializersPhaseHandler.InitializersPhaseEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addPhaseProfiling(Phases.Phase.INIT);
        } else {
            this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.INIT).stop();
        }
    }

    public void onInitializerExecution(InitializerExecutionHandler.InitializerExecutionEvent event) {
        PhaseProfiling profiling = this.currentModuleProfiling.getProfilingPerPhase(Phases.Phase.INIT);
        if (event.isStart()) {
            profiling.newItemProfiling(event.getInitializer());
        } else {
            profiling.getProfilingPerItem(event.getInitializer()).stop();
        }
    }

    @Override
    public void onBatchStep(BatchStepHandler.BatchStepEvent event) {
        if (event.isStart()) {
            this.currentModuleProfiling.addBatchStepProfiling(event.stepName());
        } else {
            this.currentModuleProfiling.getProfilingPerBatchStep(event.stepName()).stop();
        }
    }

    class DecoratorsProfiler {
        private List<Decorator> decorators = Lists.newArrayList();
        private Map<Decorator, Long> durations = new IdentityHashMap<Decorator, Long>();
        private long startTime;
        private Decorator currentDecorator;

        DecoratorsProfiler() {
        }

        void start(Decorator decorator) {
            this.startTime = PhasesSumUpTimeProfiler.this.system.now();
            this.currentDecorator = decorator;
        }

        void stop() {
            Long cumulatedDuration;
            if (this.durations.containsKey(this.currentDecorator)) {
                cumulatedDuration = this.durations.get(this.currentDecorator);
            } else {
                this.decorators.add(this.currentDecorator);
                cumulatedDuration = 0L;
            }
            this.durations.put(this.currentDecorator, cumulatedDuration + (PhasesSumUpTimeProfiler.this.system.now() - this.startTime));
        }

        public Map<Decorator, Long> getDurations() {
            return this.durations;
        }
    }
}

