/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import java.util.HashMap;
import java.util.Map;
import org.sonar.api.utils.System2;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.profiling.AbstractTimeProfiling;
import org.sonar.batch.profiling.ItemProfiling;

public class PhaseProfiling
extends AbstractTimeProfiling {
    private final Phases.Phase phase;
    private Map<String, ItemProfiling> profilingPerItem = new HashMap<String, ItemProfiling>();

    PhaseProfiling(System2 system, Phases.Phase phase) {
        super(system);
        this.phase = phase;
    }

    public static PhaseProfiling create(System2 system, Phases.Phase phase) {
        return new PhaseProfiling(system, phase);
    }

    public Phases.Phase phase() {
        return this.phase;
    }

    public boolean hasItems() {
        return !this.profilingPerItem.isEmpty();
    }

    public ItemProfiling getProfilingPerItem(Object item) {
        String stringOrSimpleName = this.toStringOrSimpleName(item);
        return this.profilingPerItem.get(stringOrSimpleName);
    }

    public void newItemProfiling(Object item) {
        String stringOrSimpleName = this.toStringOrSimpleName(item);
        this.profilingPerItem.put(stringOrSimpleName, new ItemProfiling(this.system(), stringOrSimpleName));
    }

    public void newItemProfiling(String itemName) {
        this.profilingPerItem.put(itemName, new ItemProfiling(this.system(), itemName));
    }

    public void merge(PhaseProfiling other) {
        super.add(other);
        for (Map.Entry<String, ItemProfiling> entry : other.profilingPerItem.entrySet()) {
            if (!this.profilingPerItem.containsKey(entry.getKey())) {
                this.newItemProfiling(entry.getKey());
            }
            this.getProfilingPerItem(entry.getKey()).add(entry.getValue());
        }
    }

    public void dump() {
        double percent = (double)this.totalTime() / 100.0;
        for (ItemProfiling itemProfiling : PhaseProfiling.truncate(PhaseProfiling.sortByDescendingTotalTime(this.profilingPerItem).values())) {
            this.println("   o " + itemProfiling.itemName() + ": ", percent, itemProfiling);
        }
    }

    private String toStringOrSimpleName(Object o) {
        String toString = o.toString();
        if (toString == null || toString.startsWith(o.getClass().getName())) {
            return o.getClass().getSimpleName();
        }
        return toString;
    }
}

