/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.index.ResourcePersister;

public class UpdateStatusJob
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateStatusJob.class);
    private DatabaseSession session;
    private ServerClient server;
    private Snapshot snapshot;
    private ResourcePersister resourcePersister;
    private Settings settings;
    private Project project;
    private AnalysisMode analysisMode;

    public UpdateStatusJob(Settings settings, ServerClient server, DatabaseSession session, ResourcePersister resourcePersister, Project project, Snapshot snapshot, AnalysisMode analysisMode) {
        this.session = session;
        this.server = server;
        this.resourcePersister = resourcePersister;
        this.project = project;
        this.snapshot = snapshot;
        this.settings = settings;
        this.analysisMode = analysisMode;
    }

    public void execute() {
        this.disablePreviousSnapshot();
        this.enableCurrentSnapshot();
        this.evictPreviewDB();
    }

    @VisibleForTesting
    void evictPreviewDB() {
        if (this.analysisMode.isPreview()) {
            return;
        }
        String url = "/batch_bootstrap/evict?project=" + this.project.getId();
        try {
            LOG.debug("Evict preview database");
            this.server.request(url);
        }
        catch (Exception e) {
            throw new SonarException("Unable to evict preview database: " + url, (Throwable)e);
        }
    }

    private void disablePreviousSnapshot() {
        Query query = this.session.createQuery("FROM " + Snapshot.class.getSimpleName() + " WHERE (root_snapshot_id=:rootId OR id=:rootId) AND scope=:scope");
        query.setParameter("rootId", (Object)this.snapshot.getId());
        query.setParameter("scope", (Object)"PRJ");
        List moduleSnapshots = query.getResultList();
        for (Snapshot moduleSnapshot : moduleSnapshots) {
            Snapshot previousLastSnapshot = this.resourcePersister.getLastSnapshot(moduleSnapshot, true);
            if (previousLastSnapshot == null) continue;
            this.setFlags(previousLastSnapshot, false, null);
        }
    }

    private void enableCurrentSnapshot() {
        Snapshot previousLastSnapshot = this.resourcePersister.getLastSnapshot(this.snapshot, false);
        boolean isLast = previousLastSnapshot == null || previousLastSnapshot.getCreatedAt().before(this.snapshot.getCreatedAt());
        this.setFlags(this.snapshot, isLast, "P");
        this.logSuccess(LoggerFactory.getLogger(this.getClass()));
    }

    @VisibleForTesting
    void logSuccess(Logger logger) {
        if (this.analysisMode.isPreview()) {
            logger.info("ANALYSIS SUCCESSFUL");
        } else {
            String baseUrl = this.settings.getString("sonar.core.serverBaseURL");
            if (baseUrl.equals(this.settings.getDefaultValue("sonar.core.serverBaseURL"))) {
                baseUrl = this.server.getURL();
            }
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            String url = baseUrl + "dashboard/index/" + this.project.getKey();
            logger.info("ANALYSIS SUCCESSFUL, you can browse {}", (Object)url);
        }
    }

    private void setFlags(Snapshot snapshot, boolean last, String status) {
        String hql = "UPDATE " + Snapshot.class.getSimpleName() + " SET last=:last";
        if (status != null) {
            hql = hql + ", status=:status ";
        }
        hql = hql + " WHERE root_snapshot_id=:rootId OR id=:rootId OR (path LIKE :path AND root_snapshot_id=:pathRootId)";
        Query query = this.session.createQuery(hql);
        if (status != null) {
            query.setParameter("status", (Object)status);
            snapshot.setStatus(status);
        }
        query.setParameter("last", (Object)last);
        query.setParameter("rootId", (Object)snapshot.getId());
        query.setParameter("path", (Object)(snapshot.getPath() + snapshot.getId() + ".%"));
        query.setParameter("pathRootId", (Object)(snapshot.getRootId() == null ? snapshot.getId() : snapshot.getRootId()));
        query.executeUpdate();
        this.session.commit();
        snapshot.setLast(Boolean.valueOf(last));
    }
}

