/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public class Phases {
    private final Set<Phase> enabled = Sets.newHashSet();

    public Phases enable(Phase ... phases) {
        this.enabled.addAll(Arrays.asList(phases));
        return this;
    }

    public boolean isEnabled(Phase phase) {
        return this.enabled.contains((Object)phase);
    }

    public boolean isFullyEnabled() {
        return this.enabled.containsAll(Arrays.asList(Phase.values()));
    }

    public static enum Phase {
        MAVEN("Maven"),
        INIT("Initializers"),
        SENSOR("Sensors"),
        DECORATOR("Decorators"),
        PERSISTER("Persisters"),
        POSTJOB("Post-Jobs");

        private final String label;

        private Phase(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

