/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.batch.events.BatchStepEvent;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.index.ScanPersister;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.batch.phases.DecoratorsExecutor;
import org.sonar.batch.phases.InitializersExecutor;
import org.sonar.batch.phases.MavenPhaseEvent;
import org.sonar.batch.phases.PersisterExecutionEvent;
import org.sonar.batch.phases.PersistersPhaseEvent;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.PostJobsExecutor;
import org.sonar.batch.phases.ProjectAnalysisEvent;
import org.sonar.batch.phases.ProjectInitializer;
import org.sonar.batch.phases.SensorsExecutor;
import org.sonar.batch.phases.UpdateStatusJob;
import org.sonar.batch.rule.QProfileVerifier;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.FileSystemLogger;
import org.sonar.batch.scan.maven.MavenPluginsConfigurator;
import org.sonar.batch.scan.report.JsonReport;

public final class PhaseExecutor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PhaseExecutor.class);
    private final EventBus eventBus;
    private final Phases phases;
    private final DecoratorsExecutor decoratorsExecutor;
    private final MavenPluginsConfigurator mavenPluginsConfigurator;
    private final PostJobsExecutor postJobsExecutor;
    private final InitializersExecutor initializersExecutor;
    private final SensorsExecutor sensorsExecutor;
    private final UpdateStatusJob updateStatusJob;
    private final PersistenceManager persistenceManager;
    private final SensorContext sensorContext;
    private final DefaultIndex index;
    private final ProjectInitializer pi;
    private final ScanPersister[] persisters;
    private final FileSystemLogger fsLogger;
    private final JsonReport jsonReport;
    private final DefaultModuleFileSystem fs;
    private final QProfileVerifier profileVerifier;
    private final IssueExclusionsLoader issueExclusionsLoader;

    public PhaseExecutor(Phases phases, DecoratorsExecutor decoratorsExecutor, MavenPluginsConfigurator mavenPluginsConfigurator, InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, PersistenceManager persistenceManager, SensorContext sensorContext, DefaultIndex index, EventBus eventBus, UpdateStatusJob updateStatusJob, ProjectInitializer pi, ScanPersister[] persisters, FileSystemLogger fsLogger, JsonReport jsonReport, DefaultModuleFileSystem fs, QProfileVerifier profileVerifier, IssueExclusionsLoader issueExclusionsLoader) {
        this.phases = phases;
        this.decoratorsExecutor = decoratorsExecutor;
        this.mavenPluginsConfigurator = mavenPluginsConfigurator;
        this.postJobsExecutor = postJobsExecutor;
        this.initializersExecutor = initializersExecutor;
        this.sensorsExecutor = sensorsExecutor;
        this.persistenceManager = persistenceManager;
        this.sensorContext = sensorContext;
        this.index = index;
        this.eventBus = eventBus;
        this.updateStatusJob = updateStatusJob;
        this.pi = pi;
        this.persisters = persisters;
        this.fsLogger = fsLogger;
        this.jsonReport = jsonReport;
        this.fs = fs;
        this.profileVerifier = profileVerifier;
        this.issueExclusionsLoader = issueExclusionsLoader;
    }

    public static Collection<Class> getPhaseClasses() {
        return Lists.newArrayList((Object[])new Class[]{DecoratorsExecutor.class, MavenPluginsConfigurator.class, PostJobsExecutor.class, SensorsExecutor.class, InitializersExecutor.class, ProjectInitializer.class, UpdateStatusJob.class});
    }

    public void execute(Project module) {
        this.pi.execute(module);
        this.eventBus.fireEvent(new ProjectAnalysisEvent(module, true));
        this.executeMavenPhase(module);
        this.executeInitializersPhase();
        if (this.phases.isEnabled(Phases.Phase.SENSOR)) {
            this.fs.index();
            this.profileVerifier.execute();
            this.issueExclusionsLoader.execute();
            this.sensorsExecutor.execute(this.sensorContext);
        }
        if (this.phases.isEnabled(Phases.Phase.DECORATOR)) {
            this.decoratorsExecutor.execute();
        }
        if (module.isRoot()) {
            this.jsonReport.execute();
            this.executePersisters();
            this.updateStatusJob();
            if (this.phases.isEnabled(Phases.Phase.POSTJOB)) {
                this.postJobsExecutor.execute(this.sensorContext);
            }
        }
        this.cleanMemory();
        this.eventBus.fireEvent(new ProjectAnalysisEvent(module, false));
    }

    private void executePersisters() {
        LOGGER.info("Store results in database");
        this.eventBus.fireEvent(new PersistersPhaseEvent(Lists.newArrayList((Object[])this.persisters), true));
        for (ScanPersister persister : this.persisters) {
            LOGGER.debug("Execute {}", (Object)persister.getClass().getName());
            this.eventBus.fireEvent(new PersisterExecutionEvent(persister, true));
            persister.persist();
            this.eventBus.fireEvent(new PersisterExecutionEvent(persister, false));
        }
        this.eventBus.fireEvent(new PersistersPhaseEvent(Lists.newArrayList((Object[])this.persisters), false));
    }

    private void updateStatusJob() {
        if (this.updateStatusJob != null) {
            String stepName = "Update status job";
            this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
            this.updateStatusJob.execute();
            this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
        }
    }

    private void executeInitializersPhase() {
        if (this.phases.isEnabled(Phases.Phase.INIT)) {
            this.initializersExecutor.execute();
            this.fsLogger.log();
        }
    }

    private void executeMavenPhase(Project module) {
        if (this.phases.isEnabled(Phases.Phase.MAVEN)) {
            this.eventBus.fireEvent(new MavenPhaseEvent(true));
            this.mavenPluginsConfigurator.execute(module);
            this.eventBus.fireEvent(new MavenPhaseEvent(false));
        }
    }

    private void cleanMemory() {
        String cleanMemory = "Clean memory";
        this.eventBus.fireEvent(new BatchStepEvent(cleanMemory, true));
        this.persistenceManager.clear();
        this.index.clear();
        this.eventBus.fireEvent(new BatchStepEvent(cleanMemory, false));
    }
}

