/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Initializer;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.phases.InitializerExecutionEvent;
import org.sonar.batch.phases.InitializersPhaseEvent;
import org.sonar.batch.phases.SensorsExecutor;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

public class InitializersExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SensorsExecutor.class);
    private MavenPluginExecutor mavenExecutor;
    private DefaultModuleFileSystem fs;
    private Project project;
    private BatchExtensionDictionnary selector;
    private EventBus eventBus;

    public InitializersExecutor(BatchExtensionDictionnary selector, Project project, DefaultModuleFileSystem fs, MavenPluginExecutor mavenExecutor, EventBus eventBus) {
        this.selector = selector;
        this.mavenExecutor = mavenExecutor;
        this.project = project;
        this.fs = fs;
        this.eventBus = eventBus;
    }

    public void execute() {
        Collection initializers = this.selector.select(Initializer.class, this.project, true);
        this.eventBus.fireEvent(new InitializersPhaseEvent(Lists.newArrayList((Iterable)initializers), true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializers : {}", (Object)StringUtils.join((Collection)initializers, (String)" -> "));
        }
        for (Initializer initializer : initializers) {
            this.eventBus.fireEvent(new InitializerExecutionEvent(initializer, true));
            this.executeMavenPlugin(initializer);
            TimeProfiler profiler = new TimeProfiler(LOG).start("Initializer " + initializer);
            initializer.execute(this.project);
            profiler.stop();
            this.eventBus.fireEvent(new InitializerExecutionEvent(initializer, false));
        }
        this.eventBus.fireEvent(new InitializersPhaseEvent(Lists.newArrayList((Iterable)initializers), false));
    }

    private void executeMavenPlugin(Initializer sensor) {
        MavenPluginHandler handler;
        if (sensor instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)sensor).getMavenPluginHandler(this.project)) != null) {
            TimeProfiler profiler = new TimeProfiler(LOG).start("Execute maven plugin " + handler.getArtifactId());
            this.mavenExecutor.execute(this.project, this.fs, handler);
            profiler.stop();
        }
    }
}

