/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.mediumtest;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarPlugin;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.debt.internal.DefaultDebtModel;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.duplication.DuplicationGroup;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.symbol.Symbol;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.batch.bootstrap.PluginsReferential;
import org.sonar.batch.bootstrap.TaskProperties;
import org.sonar.batch.bootstrapper.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.highlighting.SyntaxHighlightingData;
import org.sonar.batch.highlighting.SyntaxHighlightingRule;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.protocol.input.ActiveRule;
import org.sonar.batch.protocol.input.GlobalReferentials;
import org.sonar.batch.protocol.input.ProjectReferentials;
import org.sonar.batch.protocol.input.QProfile;
import org.sonar.batch.referential.GlobalReferentialsLoader;
import org.sonar.batch.referential.ProjectReferentialsLoader;
import org.sonar.batch.scan.filesystem.InputPathCache;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.batch.scan2.ProjectScanContainer;
import org.sonar.batch.scan2.ScanTaskObserver;
import org.sonar.batch.symbol.SymbolData;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.RemotePlugin;

public class BatchMediumTester {
    private Batch batch;

    public static BatchMediumTesterBuilder builder() {
        return new BatchMediumTesterBuilder().registerCoreMetrics();
    }

    public void start() {
        this.batch.start();
    }

    public void stop() {
        this.batch.stop();
    }

    private BatchMediumTester(BatchMediumTesterBuilder builder) {
        this.batch = Batch.builder().setEnableLoggingConfiguration(true).addComponents(new EnvironmentInformation("mediumTest", "1.0"), builder.pluginsReferential, builder.globalRefProvider, builder.projectRefProvider, new DefaultDebtModel()).setBootstrapProperties(builder.bootstrapProperties).build();
    }

    public TaskBuilder newTask() {
        return new TaskBuilder(this);
    }

    public TaskBuilder newScanTask(File sonarProps) {
        Properties prop = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(sonarProps);
            prop.load(reader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read configuration file", e);
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        TaskBuilder builder = new TaskBuilder(this);
        builder.property("sonar.task", "scan");
        builder.property("sonar.projectBaseDir", sonarProps.getParentFile().getAbsolutePath());
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            builder.property(entry.getKey().toString(), entry.getValue().toString());
        }
        return builder;
    }

    private static class FakePluginsReferential
    implements PluginsReferential {
        private List<RemotePlugin> pluginList = new ArrayList<RemotePlugin>();
        private Map<RemotePlugin, File> pluginFiles = new HashMap<RemotePlugin, File>();
        Map<PluginMetadata, SonarPlugin> localPlugins = new HashMap<PluginMetadata, SonarPlugin>();

        private FakePluginsReferential() {
        }

        @Override
        public List<RemotePlugin> pluginList() {
            return this.pluginList;
        }

        @Override
        public File pluginFile(RemotePlugin remote) {
            return this.pluginFiles.get(remote);
        }

        public FakePluginsReferential addPlugin(String pluginKey, File location) {
            RemotePlugin plugin = new RemotePlugin(pluginKey, false);
            this.pluginList.add(plugin);
            this.pluginFiles.put(plugin, location);
            return this;
        }

        public FakePluginsReferential addPlugin(String pluginKey, SonarPlugin pluginInstance) {
            this.localPlugins.put((PluginMetadata)DefaultPluginMetadata.create((String)pluginKey), pluginInstance);
            return this;
        }

        @Override
        public Map<PluginMetadata, SonarPlugin> localPlugins() {
            return this.localPlugins;
        }
    }

    private static class FakeProjectReferentialsLoader
    implements ProjectReferentialsLoader {
        private ProjectReferentials ref = new ProjectReferentials();

        private FakeProjectReferentialsLoader() {
        }

        @Override
        public ProjectReferentials load(ProjectReactor reactor, TaskProperties taskProperties) {
            return this.ref;
        }

        public FakeProjectReferentialsLoader addQProfile(String language, String name) {
            this.ref.addQProfile(new QProfile(name, name, language, new Date()));
            return this;
        }

        public FakeProjectReferentialsLoader addActiveRule(ActiveRule activeRule) {
            this.ref.addActiveRule(activeRule);
            return this;
        }
    }

    private static class FakeGlobalReferentialsLoader
    implements GlobalReferentialsLoader {
        private int metricId = 1;
        private GlobalReferentials ref = new GlobalReferentials();

        private FakeGlobalReferentialsLoader() {
        }

        @Override
        public GlobalReferentials load() {
            return this.ref;
        }

        public Map<String, String> globalSettings() {
            return this.ref.globalSettings();
        }

        public FakeGlobalReferentialsLoader add(Metric metric) {
            Boolean optimizedBestValue = metric.isOptimizedBestValue();
            this.ref.metrics().add(new org.sonar.batch.protocol.input.Metric(this.metricId, metric.key(), metric.getType().name(), metric.getDescription(), metric.getDirection().intValue(), metric.getName(), metric.getQualitative().booleanValue(), metric.getUserManaged().booleanValue(), metric.getWorstValue(), metric.getBestValue(), optimizedBestValue != null ? optimizedBestValue : false));
            ++this.metricId;
            return this;
        }
    }

    public static class TaskResult
    implements ScanTaskObserver {
        private static final Logger LOG = LoggerFactory.getLogger(TaskResult.class);
        private List<Issue> issues = new ArrayList<Issue>();
        private List<Measure> measures = new ArrayList<Measure>();
        private Map<String, List<DuplicationGroup>> duplications = new HashMap<String, List<DuplicationGroup>>();
        private List<InputFile> inputFiles = new ArrayList<InputFile>();
        private List<InputDir> inputDirs = new ArrayList<InputDir>();
        private Map<InputFile, SyntaxHighlightingData> highlightingPerFile = new HashMap<InputFile, SyntaxHighlightingData>();
        private Map<InputFile, SymbolData> symbolTablePerFile = new HashMap<InputFile, SymbolData>();

        @Override
        public void scanTaskCompleted(ProjectScanContainer container) {
            LOG.info("Store analysis results in memory for later assertions in medium test");
            for (DefaultIssue issue : ((AnalyzerIssueCache)container.getComponentByType(AnalyzerIssueCache.class)).all()) {
                this.issues.add((Issue)issue);
            }
            for (DefaultMeasure measure : ((AnalyzerMeasureCache)container.getComponentByType(AnalyzerMeasureCache.class)).all()) {
                this.measures.add((Measure)measure);
            }
            InputPathCache inputFileCache = (InputPathCache)container.getComponentByType(InputPathCache.class);
            for (InputPath inputPath : inputFileCache.all()) {
                if (inputPath instanceof InputFile) {
                    this.inputFiles.add((InputFile)inputPath);
                    continue;
                }
                this.inputDirs.add((InputDir)inputPath);
            }
            ComponentDataCache componentDataCache = (ComponentDataCache)container.getComponentByType(ComponentDataCache.class);
            for (InputFile file : this.inputFiles) {
                SymbolData symbolTable;
                SyntaxHighlightingData highlighting = (SyntaxHighlightingData)componentDataCache.getData(((DefaultInputFile)file).key(), "highlight_syntax");
                if (highlighting != null) {
                    this.highlightingPerFile.put(file, highlighting);
                }
                if ((symbolTable = (SymbolData)componentDataCache.getData(((DefaultInputFile)file).key(), "symbol")) == null) continue;
                this.symbolTablePerFile.put(file, symbolTable);
            }
            DuplicationCache duplicationCache = (DuplicationCache)container.getComponentByType(DuplicationCache.class);
            for (Cache.Entry<List<DuplicationGroup>> entry : duplicationCache.entries()) {
                String effectiveKey = entry.key()[0].toString();
                this.duplications.put(effectiveKey, entry.value());
            }
        }

        public List<Issue> issues() {
            return this.issues;
        }

        public List<Measure> measures() {
            return this.measures;
        }

        public List<InputFile> inputFiles() {
            return this.inputFiles;
        }

        public List<InputDir> inputDirs() {
            return this.inputDirs;
        }

        public List<DuplicationGroup> duplicationsFor(InputFile inputFile) {
            return this.duplications.get(((DefaultInputFile)inputFile).key());
        }

        public List<TypeOfText> highlightingTypeFor(InputFile file, int charIndex) {
            SyntaxHighlightingData syntaxHighlightingData = this.highlightingPerFile.get(file);
            if (syntaxHighlightingData == null) {
                return Collections.emptyList();
            }
            ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
            for (SyntaxHighlightingRule sortedRule : syntaxHighlightingData.syntaxHighlightingRuleSet()) {
                if (sortedRule.getStartPosition() > charIndex || sortedRule.getEndPosition() <= charIndex) continue;
                result.add(sortedRule.getTextType());
            }
            return result;
        }

        @CheckForNull
        public Set<Integer> symbolReferencesFor(InputFile file, int symbolStartOffset, int symbolEndOffset) {
            SymbolData data = this.symbolTablePerFile.get(file);
            if (data == null) {
                return null;
            }
            for (Symbol symbol : data.referencesBySymbol().keySet()) {
                if (symbol.getDeclarationStartOffset() != symbolStartOffset || symbol.getDeclarationEndOffset() != symbolEndOffset) continue;
                return data.referencesBySymbol().get((Object)symbol);
            }
            return null;
        }
    }

    public static class TaskBuilder {
        private final Map<String, String> taskProperties = new HashMap<String, String>();
        private BatchMediumTester tester;

        public TaskBuilder(BatchMediumTester tester) {
            this.tester = tester;
        }

        public TaskResult start() {
            TaskResult result = new TaskResult();
            this.tester.batch.executeTask(this.taskProperties, result);
            return result;
        }

        public TaskBuilder properties(Map<String, String> props) {
            this.taskProperties.putAll(props);
            return this;
        }

        public TaskBuilder property(String key, String value) {
            this.taskProperties.put(key, value);
            return this;
        }
    }

    public static class BatchMediumTesterBuilder {
        private final FakeGlobalReferentialsLoader globalRefProvider = new FakeGlobalReferentialsLoader();
        private final FakeProjectReferentialsLoader projectRefProvider = new FakeProjectReferentialsLoader();
        private final FakePluginsReferential pluginsReferential = new FakePluginsReferential();
        private final Map<String, String> bootstrapProperties = new HashMap<String, String>();

        public BatchMediumTester build() {
            return new BatchMediumTester(this);
        }

        public BatchMediumTesterBuilder registerPlugin(String pluginKey, File location) {
            this.pluginsReferential.addPlugin(pluginKey, location);
            return this;
        }

        public BatchMediumTesterBuilder registerPlugin(String pluginKey, SonarPlugin instance) {
            this.pluginsReferential.addPlugin(pluginKey, instance);
            return this;
        }

        public BatchMediumTesterBuilder registerCoreMetrics() {
            for (Metric m : CoreMetrics.getMetrics()) {
                this.registerMetric(m);
            }
            return this;
        }

        public BatchMediumTesterBuilder registerMetric(Metric<?> metric) {
            this.globalRefProvider.add(metric);
            return this;
        }

        public BatchMediumTesterBuilder addQProfile(String language, String name) {
            this.projectRefProvider.addQProfile(language, name);
            return this;
        }

        public BatchMediumTesterBuilder addDefaultQProfile(String language, String name) {
            this.addQProfile(language, name);
            this.globalRefProvider.globalSettings().put("sonar.profile." + language, name);
            return this;
        }

        public BatchMediumTesterBuilder bootstrapProperties(Map<String, String> props) {
            this.bootstrapProperties.putAll(props);
            return this;
        }

        public BatchMediumTesterBuilder activateRule(ActiveRule activeRule) {
            this.projectRefProvider.addActiveRule(activeRule);
            return this;
        }
    }
}

