/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.maven.MavenUtils;
import org.sonar.api.task.TaskExtension;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;

@Deprecated
@SupportedEnvironment(value={"maven"})
public class MavenProjectConverter
implements TaskExtension {
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options, which is not supported by SonarQube and should not be used.";

    public ProjectDefinition configure(List<MavenProject> poms, MavenProject root) {
        HashMap paths = Maps.newHashMap();
        HashMap defs = Maps.newHashMap();
        try {
            this.configureModules(poms, paths, defs);
            this.rebuildModuleHierarchy(paths, defs);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot configure project", e);
        }
        ProjectDefinition rootProject = (ProjectDefinition)defs.get(root);
        if (rootProject == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        return rootProject;
    }

    private void rebuildModuleHierarchy(Map<String, MavenProject> paths, Map<MavenProject, ProjectDefinition> defs) throws IOException {
        for (Map.Entry<String, MavenProject> entry : paths.entrySet()) {
            MavenProject pom = entry.getValue();
            Iterator i$ = pom.getModules().iterator();
            while (i$.hasNext()) {
                String m;
                String moduleId = m = (String)i$.next();
                File modulePath = new File(pom.getBasedir(), moduleId);
                MavenProject module = MavenProjectConverter.findMavenProject(modulePath, paths);
                ProjectDefinition parentProject = defs.get(pom);
                if (parentProject == null) {
                    throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                }
                ProjectDefinition subProject = defs.get(module);
                if (subProject == null) {
                    throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                }
                parentProject.addSubProject(subProject);
            }
        }
    }

    private void configureModules(List<MavenProject> poms, Map<String, MavenProject> paths, Map<MavenProject, ProjectDefinition> defs) throws IOException {
        for (MavenProject pom : poms) {
            paths.put(pom.getFile().getCanonicalPath(), pom);
            ProjectDefinition def = ProjectDefinition.create();
            this.merge(pom, def);
            defs.put(pom, def);
        }
    }

    private static MavenProject findMavenProject(File modulePath, Map<String, MavenProject> paths) throws IOException {
        if (modulePath.exists() && modulePath.isDirectory()) {
            for (Map.Entry<String, MavenProject> entry : paths.entrySet()) {
                String pomFileParentDir = new File(entry.getKey()).getParent();
                if (!pomFileParentDir.equals(modulePath.getCanonicalPath())) continue;
                return entry.getValue();
            }
            return null;
        }
        return paths.get(modulePath.getCanonicalPath());
    }

    @VisibleForTesting
    void merge(MavenProject pom, ProjectDefinition definition) {
        String key = MavenProjectConverter.getSonarKey(pom);
        definition.setProperties(pom.getModel().getProperties()).setKey(key).setVersion(pom.getVersion()).setName(pom.getName()).setDescription(pom.getDescription()).addContainerExtension((Object)pom);
        MavenProjectConverter.guessJavaVersion(pom, definition);
        MavenProjectConverter.guessEncoding(pom, definition);
        MavenProjectConverter.convertMavenLinksToProperties(definition, pom);
        this.synchronizeFileSystem(pom, definition);
    }

    private static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    private static void guessEncoding(MavenProject pom, ProjectDefinition definition) {
        String encoding = MavenUtils.getSourceEncoding((MavenProject)pom);
        if (encoding != null) {
            definition.setProperty("sonar.sourceEncoding", encoding);
        }
    }

    private static void guessJavaVersion(MavenProject pom, ProjectDefinition definition) {
        String version = MavenUtils.getJavaSourceVersion((MavenProject)pom);
        if (version != null) {
            definition.setProperty("sonar.java.source", version);
        }
        if ((version = MavenUtils.getJavaVersion((MavenProject)pom)) != null) {
            definition.setProperty("sonar.java.target", version);
        }
    }

    private static void convertMavenLinksToProperties(ProjectDefinition definition, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.homepage", pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm", scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm_dev", scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.ci", ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.issue", issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(ProjectDefinition definition, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)definition.getProperties().getProperty(propertyKey))) {
            definition.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    public void synchronizeFileSystem(MavenProject pom, ProjectDefinition into) {
        into.setBaseDir(pom.getBasedir());
        File buildDir = MavenProjectConverter.getBuildDir(pom);
        if (buildDir != null) {
            into.setBuildDir(buildDir);
            into.setWorkDir(MavenProjectConverter.getSonarWorkDir(pom));
        }
        into.setSourceDirs(MavenProjectConverter.toPaths(this.mainDirs(pom)));
        into.setTestDirs(MavenProjectConverter.toPaths(this.testDirs(pom)));
        File binaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir());
        if (binaryDir != null) {
            into.addBinaryDir(binaryDir);
        }
    }

    public static File getSonarWorkDir(MavenProject pom) {
        return new File(MavenProjectConverter.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    public void synchronizeFileSystem(MavenProject pom, DefaultModuleFileSystem into) {
        into.resetDirs(pom.getBasedir(), MavenProjectConverter.getBuildDir(pom), this.mainDirs(pom), this.testDirs(pom), Arrays.asList(MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir())));
    }

    static File resolvePath(@Nullable String path, File basedir) {
        if (path != null) {
            File file = new File(StringUtils.trim((String)path));
            if (!file.isAbsolute()) {
                try {
                    file = new File(basedir, path).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to resolve path '" + path + "'", e);
                }
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(List<String> paths, File basedir) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            File dir = MavenProjectConverter.resolvePath(path, basedir);
            if (dir == null) continue;
            result.add(dir);
        }
        return result;
    }

    private List<File> mainDirs(MavenProject pom) {
        return this.sourceDirs(pom, "sonar.sources", pom.getCompileSourceRoots());
    }

    private List<File> testDirs(MavenProject pom) {
        return this.sourceDirs(pom, "sonar.tests", pom.getTestCompileSourceRoots());
    }

    private List<File> sourceDirs(MavenProject pom, String propertyKey, List mavenDirs) {
        String prop = pom.getProperties().getProperty(propertyKey);
        if (prop != null) {
            List<String> paths = Arrays.asList(StringUtils.split((String)prop, (String)","));
            return this.existingDirsOrFail(MavenProjectConverter.resolvePaths(paths, pom.getBasedir()), pom, propertyKey);
        }
        List<File> dirs = MavenProjectConverter.resolvePaths(mavenDirs, pom.getBasedir());
        return MavenProjectConverter.keepExistingDirs(dirs);
    }

    private List<File> existingDirsOrFail(List<File> dirs, MavenProject pom, String propertyKey) {
        for (File dir : dirs) {
            if (dir.isDirectory() && dir.exists()) continue;
            throw MessageException.of((String)String.format("The directory '%s' does not exist for Maven module %s. Please check the property %s", dir.getAbsolutePath(), pom.getId(), propertyKey));
        }
        return dirs;
    }

    private static List<File> keepExistingDirs(List<File> files) {
        return Lists.newArrayList((Iterable)Collections2.filter(files, (Predicate)new Predicate<File>(){

            public boolean apply(File dir) {
                return dir != null && dir.exists() && dir.isDirectory();
            }
        }));
    }

    private static String[] toPaths(Collection<File> dirs) {
        Collection paths = Collections2.transform(dirs, (Function)new Function<File, String>(){

            public String apply(File dir) {
                return dir.getAbsolutePath();
            }
        });
        return paths.toArray(new String[paths.size()]);
    }
}

