/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.scanner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.batch.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;
import org.sonar.batch.issue.ignore.pattern.LineRange;

public class IssueExclusionsRegexpScanner
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(IssueExclusionsRegexpScanner.class);
    private IssueExclusionPatternInitializer exclusionPatternInitializer;
    private List<Pattern> allFilePatterns;
    private List<DoubleRegexpMatcher> blockMatchers;
    private DoubleRegexpMatcher currentMatcher;
    private int fileLength;
    private List<LineExclusion> lineExclusions;
    private LineExclusion currentLineExclusion;

    public IssueExclusionsRegexpScanner(IssueExclusionPatternInitializer patternsInitializer) {
        this.exclusionPatternInitializer = patternsInitializer;
        this.lineExclusions = Lists.newArrayList();
        this.allFilePatterns = Lists.newArrayList();
        this.blockMatchers = Lists.newArrayList();
        for (IssuePattern pattern : patternsInitializer.getAllFilePatterns()) {
            this.allFilePatterns.add(Pattern.compile(pattern.getAllFileRegexp()));
        }
        for (IssuePattern pattern : patternsInitializer.getBlockPatterns()) {
            this.blockMatchers.add(new DoubleRegexpMatcher(Pattern.compile(pattern.getBeginBlockRegexp()), Pattern.compile(pattern.getEndBlockRegexp())));
        }
        this.init();
    }

    private void init() {
        this.currentMatcher = null;
        this.fileLength = 0;
        this.lineExclusions.clear();
        this.currentLineExclusion = null;
    }

    public void scan(String resource, File file, Charset sourcesEncoding) throws IOException {
        LOG.debug("Scanning {}", (Object)resource);
        this.init();
        List lines = FileUtils.readLines((File)file, (String)sourcesEncoding.name());
        int lineIndex = 0;
        for (String line : lines) {
            ++lineIndex;
            if (line.trim().length() == 0) continue;
            for (Pattern pattern : this.allFilePatterns) {
                if (!pattern.matcher(line).find()) continue;
                this.exclusionPatternInitializer.getPatternMatcher().addPatternToExcludeResource(resource);
                LOG.debug("- Exclusion pattern '{}': every violation in this file will be ignored.", (Object)pattern);
                return;
            }
            this.checkDoubleRegexps(line, lineIndex);
        }
        if (this.currentMatcher != null && !this.currentMatcher.hasSecondPattern()) {
            this.endExclusion(lineIndex + 1);
        }
        this.fileLength = lineIndex;
        if (!this.lineExclusions.isEmpty()) {
            Set<LineRange> lineRanges = this.convertLineExclusionsToLineRanges();
            LOG.debug("- Line exclusions found: {}", lineRanges);
            this.exclusionPatternInitializer.getPatternMatcher().addPatternToExcludeLines(resource, lineRanges);
        }
    }

    private Set<LineRange> convertLineExclusionsToLineRanges() {
        HashSet lineRanges = Sets.newHashSet();
        for (LineExclusion lineExclusion : this.lineExclusions) {
            lineRanges.add(lineExclusion.toLineRange());
        }
        return lineRanges;
    }

    private void checkDoubleRegexps(String line, int lineIndex) {
        if (this.currentMatcher == null) {
            for (DoubleRegexpMatcher matcher : this.blockMatchers) {
                if (!matcher.matchesFirstPattern(line)) continue;
                this.startExclusion(lineIndex);
                this.currentMatcher = matcher;
                break;
            }
        } else if (this.currentMatcher.matchesSecondPattern(line)) {
            this.endExclusion(lineIndex);
            this.currentMatcher = null;
        }
    }

    private void startExclusion(int lineIndex) {
        this.currentLineExclusion = new LineExclusion(lineIndex);
        this.lineExclusions.add(this.currentLineExclusion);
    }

    private void endExclusion(int lineIndex) {
        this.currentLineExclusion.setEnd(lineIndex);
        this.currentLineExclusion = null;
    }

    private static class DoubleRegexpMatcher {
        private Pattern firstPattern;
        private Pattern secondPattern;

        DoubleRegexpMatcher(Pattern firstPattern, Pattern secondPattern) {
            this.firstPattern = firstPattern;
            this.secondPattern = secondPattern;
        }

        boolean matchesFirstPattern(String line) {
            return this.firstPattern.matcher(line).find();
        }

        boolean matchesSecondPattern(String line) {
            return this.hasSecondPattern() && this.secondPattern.matcher(line).find();
        }

        boolean hasSecondPattern() {
            return StringUtils.isNotEmpty((String)this.secondPattern.toString());
        }
    }

    private class LineExclusion {
        private int start;
        private int end;

        LineExclusion(int start) {
            this.start = start;
            this.end = -1;
        }

        void setEnd(int end) {
            this.end = end;
        }

        public LineRange toLineRange() {
            return new LineRange(this.start, this.end == -1 ? IssueExclusionsRegexpScanner.this.fileLength : this.end);
        }
    }
}

