/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.batch.issue.ignore.pattern.AbstractPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;
import org.sonar.batch.issue.ignore.pattern.PatternDecoder;
import org.sonar.batch.issue.ignore.pattern.PatternMatcher;

public class IssueExclusionPatternInitializer
extends AbstractPatternInitializer {
    private List<IssuePattern> blockPatterns;
    private List<IssuePattern> allFilePatterns;
    private PatternMatcher patternMatcher = new PatternMatcher();

    public IssueExclusionPatternInitializer(Settings settings) {
        super(settings);
        this.loadFileContentPatterns();
    }

    @Override
    protected String getMulticriteriaConfigurationKey() {
        return "sonar.issue.ignore.multicriteria";
    }

    public PatternMatcher getPatternMatcher() {
        return this.patternMatcher;
    }

    @Override
    public void initializePatternsForPath(String relativePath, String componentKey) {
        for (IssuePattern pattern : this.getMulticriteriaPatterns()) {
            if (!pattern.matchResource(relativePath)) continue;
            this.getPatternMatcher().addPatternForComponent(componentKey, pattern);
        }
    }

    @Override
    public boolean hasConfiguredPatterns() {
        return this.hasFileContentPattern() || this.hasMulticriteriaPatterns();
    }

    @VisibleForTesting
    protected final void loadFileContentPatterns() {
        String propPrefix;
        this.blockPatterns = Lists.newArrayList();
        String patternConf = StringUtils.defaultIfBlank((String)this.getSettings().getString("sonar.issue.ignore.block"), (String)"");
        for (String id : StringUtils.split((String)patternConf, (char)',')) {
            propPrefix = "sonar.issue.ignore.block." + id + ".";
            String beginBlockRegexp = this.getSettings().getString(propPrefix + "beginBlockRegexp");
            String endBlockRegexp = this.getSettings().getString(propPrefix + "endBlockRegexp");
            Object[] fields = new String[]{beginBlockRegexp, endBlockRegexp};
            PatternDecoder.checkDoubleRegexpLineConstraints(StringUtils.join((Object[])fields, (String)","), (String[])fields);
            IssuePattern pattern = new IssuePattern().setBeginBlockRegexp(Strings.nullToEmpty((String)beginBlockRegexp)).setEndBlockRegexp(Strings.nullToEmpty((String)endBlockRegexp));
            this.blockPatterns.add(pattern);
        }
        this.allFilePatterns = Lists.newArrayList();
        patternConf = StringUtils.defaultIfBlank((String)this.getSettings().getString("sonar.issue.ignore.allfile"), (String)"");
        for (String id : StringUtils.split((String)patternConf, (char)',')) {
            propPrefix = "sonar.issue.ignore.allfile." + id + ".";
            String allFileRegexp = this.getSettings().getString(propPrefix + "fileRegexp");
            PatternDecoder.checkWholeFileRegexp(allFileRegexp);
            IssuePattern pattern = new IssuePattern().setAllFileRegexp(Strings.nullToEmpty((String)allFileRegexp));
            this.allFilePatterns.add(pattern);
        }
    }

    public List<IssuePattern> getBlockPatterns() {
        return this.blockPatterns;
    }

    public List<IssuePattern> getAllFilePatterns() {
        return this.allFilePatterns;
    }

    public boolean hasFileContentPattern() {
        return !this.blockPatterns.isEmpty() || !this.allFilePatterns.isEmpty();
    }
}

