/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.issue.batch.IssueFilterChain;
import org.sonar.batch.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;
import org.sonar.batch.issue.ignore.pattern.PatternMatcher;

public class IgnoreIssuesFilter
implements IssueFilter {
    private PatternMatcher patternMatcher;
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreIssuesFilter.class);

    public IgnoreIssuesFilter(IssueExclusionPatternInitializer patternInitializer) {
        this.patternMatcher = patternInitializer.getPatternMatcher();
    }

    public boolean accept(Issue issue, IssueFilterChain chain) {
        if (this.hasMatchFor(issue)) {
            return false;
        }
        return chain.accept(issue);
    }

    private boolean hasMatchFor(Issue issue) {
        IssuePattern pattern = this.patternMatcher.getMatchingPattern(issue);
        if (pattern != null) {
            this.logExclusion(issue, pattern);
            return true;
        }
        return false;
    }

    private void logExclusion(Issue issue, IssuePattern pattern) {
        LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, (Object)pattern);
    }
}

