/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import javax.annotation.Nullable;
import org.sonar.api.BatchComponent;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.rules.Violation;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.issue.DefaultIssueFilterChain;
import org.sonar.batch.issue.DeprecatedViolations;

public class IssueFilters
implements BatchComponent {
    private final ViolationFilters deprecatedFilters;
    private final DeprecatedViolations deprecatedViolations;
    private final org.sonar.api.issue.IssueFilter[] exclusionFilters;
    private final IssueFilter[] filters;

    public IssueFilters(@Nullable ViolationFilters deprecatedFilters, @Nullable DeprecatedViolations deprecatedViolations, org.sonar.api.issue.IssueFilter[] exclusionFilters, IssueFilter[] filters) {
        this.deprecatedFilters = deprecatedFilters;
        this.deprecatedViolations = deprecatedViolations;
        this.exclusionFilters = exclusionFilters;
        this.filters = filters;
    }

    public IssueFilters(@Nullable ViolationFilters deprecatedFilters, @Nullable DeprecatedViolations deprecatedViolations, IssueFilter[] filters) {
        this(deprecatedFilters, deprecatedViolations, new org.sonar.api.issue.IssueFilter[0], filters);
    }

    public IssueFilters(@Nullable ViolationFilters deprecatedFilters, @Nullable DeprecatedViolations deprecatedViolations, org.sonar.api.issue.IssueFilter[] exclusionFilters) {
        this(deprecatedFilters, deprecatedViolations, exclusionFilters, new IssueFilter[0]);
    }

    public IssueFilters(@Nullable ViolationFilters deprecatedFilters, @Nullable DeprecatedViolations deprecatedViolations) {
        this(deprecatedFilters, deprecatedViolations, new org.sonar.api.issue.IssueFilter[0]);
    }

    public IssueFilters(org.sonar.api.issue.IssueFilter[] exclusionFilters, IssueFilter[] filters) {
        this(null, null, exclusionFilters, filters);
    }

    public IssueFilters(org.sonar.api.issue.IssueFilter[] exclusionFilters) {
        this(null, null, exclusionFilters, new IssueFilter[0]);
    }

    public IssueFilters(IssueFilter[] filters) {
        this(null, null, new org.sonar.api.issue.IssueFilter[0], filters);
    }

    public IssueFilters() {
        this(null, null, new org.sonar.api.issue.IssueFilter[0], new IssueFilter[0]);
    }

    public boolean accept(DefaultIssue issue, @Nullable Violation violation) {
        if (new DefaultIssueFilterChain(this.filters).accept((Issue)issue)) {
            for (org.sonar.api.issue.IssueFilter filter : this.exclusionFilters) {
                if (filter.accept((Issue)issue)) continue;
                return false;
            }
            if (this.deprecatedFilters != null && !this.deprecatedFilters.isEmpty() && this.deprecatedViolations != null) {
                Violation v = violation != null ? violation : this.deprecatedViolations.toViolation(issue);
                return !this.deprecatedFilters.isIgnored(v);
            }
            return true;
        }
        return false;
    }
}

