/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.DuplicatedSourceException;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.core.source.db.SnapshotSourceDao;
import org.sonar.core.source.db.SnapshotSourceDto;

public final class SourcePersister {
    private Set<Integer> savedSnapshotIds = Sets.newHashSet();
    private ResourcePersister resourcePersister;
    private final SnapshotSourceDao sourceDao;

    public SourcePersister(ResourcePersister resourcePersister, SnapshotSourceDao sourceDao) {
        this.resourcePersister = resourcePersister;
        this.sourceDao = sourceDao;
    }

    public void saveSource(Resource resource, String source) {
        Snapshot snapshot = this.resourcePersister.getSnapshotOrFail(resource);
        if (this.isCached(snapshot)) {
            throw new DuplicatedSourceException(resource);
        }
        SnapshotSourceDto dto = new SnapshotSourceDto();
        dto.setSnapshotId(Long.valueOf(snapshot.getId().longValue()));
        dto.setData(source);
        this.sourceDao.insert(dto);
        this.addToCache(snapshot);
    }

    @CheckForNull
    public String getSource(Resource resource) {
        Snapshot snapshot = this.resourcePersister.getSnapshot(resource);
        if (snapshot != null && snapshot.getId() != null) {
            return this.sourceDao.selectSnapshotSource((long)snapshot.getId().intValue());
        }
        return null;
    }

    private boolean isCached(Snapshot snapshot) {
        return this.savedSnapshotIds.contains(snapshot.getId());
    }

    private void addToCache(Snapshot snapshot) {
        this.savedSnapshotIds.add(snapshot.getId());
    }

    public void clear() {
        this.savedSnapshotIds.clear();
    }
}

