/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.PathUtils;
import org.sonar.batch.util.DeprecatedKeyUtils;

public class ResourceKeyMigration
implements BatchComponent {
    private static final String UNABLE_TO_UPDATE_COMPONENT_NO_MATCH_WAS_FOUND = "Unable to update component {}. No match was found.";
    private static final String COMPONENT_CHANGED_TO = "Component {} changed to {}";
    private final Logger logger;
    private final DatabaseSession session;
    private boolean migrationNeeded = false;

    public ResourceKeyMigration(DatabaseSession session) {
        this(session, LoggerFactory.getLogger(ResourceKeyMigration.class));
    }

    @VisibleForTesting
    ResourceKeyMigration(DatabaseSession session, Logger logger) {
        this.session = session;
        this.logger = logger;
    }

    public void checkIfMigrationNeeded(Project rootProject) {
        ResourceModel model = (ResourceModel)this.session.getSingleResult(ResourceModel.class, new Object[]{"key", rootProject.getEffectiveKey()});
        if (model != null && StringUtils.isBlank((String)model.getDeprecatedKey())) {
            this.migrationNeeded = true;
        }
    }

    public void migrateIfNeeded(Project module, FileSystem fs) {
        if (this.migrationNeeded) {
            this.migrateIfNeeded(module, fs.inputFiles(fs.predicates().all()));
        }
    }

    void migrateIfNeeded(Project module, Iterable<InputFile> inputFiles) {
        this.logger.info("Update component keys");
        HashMap<String, InputFile> deprecatedFileKeyMapper = new HashMap<String, InputFile>();
        HashMap<String, InputFile> deprecatedTestKeyMapper = new HashMap<String, InputFile>();
        HashMap<String, String> deprecatedDirectoryKeyMapper = new HashMap<String, String>();
        for (InputFile inputFile : inputFiles) {
            String deprecatedKey = ((DeprecatedDefaultInputFile)inputFile).deprecatedKey();
            if (deprecatedKey == null) continue;
            if (InputFile.Type.TEST == inputFile.type() && !deprecatedTestKeyMapper.containsKey(deprecatedKey)) {
                deprecatedTestKeyMapper.put(deprecatedKey, inputFile);
                continue;
            }
            if (InputFile.Type.MAIN != inputFile.type() || deprecatedFileKeyMapper.containsKey(deprecatedKey)) continue;
            deprecatedFileKeyMapper.put(deprecatedKey, inputFile);
        }
        ResourceModel moduleModel = (ResourceModel)this.session.getSingleResult(ResourceModel.class, new Object[]{"key", module.getEffectiveKey()});
        int moduleId = moduleModel.getId();
        this.migrateFiles(module, deprecatedFileKeyMapper, deprecatedTestKeyMapper, deprecatedDirectoryKeyMapper, moduleId);
        this.migrateDirectories(deprecatedDirectoryKeyMapper, moduleId);
        this.session.commit();
    }

    private void migrateFiles(Project module, Map<String, InputFile> deprecatedFileKeyMapper, Map<String, InputFile> deprecatedTestKeyMapper, Map<String, String> deprecatedDirectoryKeyMapper, int moduleId) {
        StringBuilder hql = this.newResourceQuery().append(" and scope = '").append("FIL").append("' order by qualifier, key");
        Map<String, ResourceModel> disabledResourceByKey = this.loadDisabledResources(moduleId, hql);
        List<ResourceModel> resources = this.loadEnabledResources(moduleId, hql);
        for (ResourceModel resourceModel : resources) {
            boolean isTest;
            String oldEffectiveKey = resourceModel.getKey();
            InputFile matchedFile = this.findInputFile(deprecatedFileKeyMapper, deprecatedTestKeyMapper, oldEffectiveKey, isTest = "UTS".equals(resourceModel.getQualifier()));
            if (matchedFile != null) {
                String parentOldKey;
                String newEffectiveKey = ((DeprecatedDefaultInputFile)matchedFile).key();
                String oldKey = StringUtils.substringAfterLast((String)oldEffectiveKey, (String)":");
                if ("java".equals(resourceModel.getLanguageKey())) {
                    parentOldKey = String.format("%s:%s", module.getEffectiveKey(), DeprecatedKeyUtils.getJavaFileParentDeprecatedKey(oldKey));
                } else {
                    File sonarFile = new File(oldKey);
                    parentOldKey = String.format("%s:%s", module.getEffectiveKey(), sonarFile.getParent().getDeprecatedKey());
                }
                String parentNewKey = String.format("%s:%s", module.getEffectiveKey(), this.getParentKey(matchedFile));
                if (!deprecatedDirectoryKeyMapper.containsKey(parentOldKey)) {
                    deprecatedDirectoryKeyMapper.put(parentOldKey, parentNewKey);
                } else if (!parentNewKey.equals(deprecatedDirectoryKeyMapper.get(parentOldKey))) {
                    this.logger.warn("Directory with key " + parentOldKey + " matches both " + deprecatedDirectoryKeyMapper.get(parentOldKey) + " and " + parentNewKey + ". First match is arbitrary chosen.");
                }
                this.updateKey(resourceModel, newEffectiveKey, disabledResourceByKey);
                resourceModel.setDeprecatedKey(oldEffectiveKey);
                this.logger.info(COMPONENT_CHANGED_TO, (Object)oldEffectiveKey, (Object)newEffectiveKey);
                continue;
            }
            this.logger.warn(UNABLE_TO_UPDATE_COMPONENT_NO_MATCH_WAS_FOUND, (Object)oldEffectiveKey);
        }
    }

    private void updateKey(ResourceModel resourceModel, String newEffectiveKey, Map<String, ResourceModel> disabledResourceByKey) {
        if (disabledResourceByKey.containsKey(newEffectiveKey)) {
            ResourceModel duplicateDisabledResource = disabledResourceByKey.get(newEffectiveKey);
            String disabledKey = newEffectiveKey + "_renamed_by_resource_key_migration";
            duplicateDisabledResource.setKey(disabledKey);
            this.logger.info(COMPONENT_CHANGED_TO, (Object)newEffectiveKey, (Object)disabledKey);
        }
        resourceModel.setKey(newEffectiveKey);
    }

    private StringBuilder newResourceQuery() {
        return new StringBuilder().append("from ").append(ResourceModel.class.getSimpleName()).append(" where enabled = :enabled").append(" and rootId = :rootId ");
    }

    private InputFile findInputFile(Map<String, InputFile> deprecatedFileKeyMapper, Map<String, InputFile> deprecatedTestKeyMapper, String oldEffectiveKey, boolean isTest) {
        if (isTest) {
            return deprecatedTestKeyMapper.get(oldEffectiveKey);
        }
        return deprecatedFileKeyMapper.get(oldEffectiveKey);
    }

    private void migrateDirectories(Map<String, String> deprecatedDirectoryKeyMapper, int moduleId) {
        StringBuilder hql = this.newResourceQuery().append(" and qualifier = '").append("DIR").append("'");
        Map<String, ResourceModel> disabledResourceByKey = this.loadDisabledResources(moduleId, hql);
        List<ResourceModel> resources = this.loadEnabledResources(moduleId, hql);
        for (ResourceModel resourceModel : resources) {
            String oldEffectiveKey = resourceModel.getKey();
            if (deprecatedDirectoryKeyMapper.containsKey(oldEffectiveKey)) {
                String newEffectiveKey = deprecatedDirectoryKeyMapper.get(oldEffectiveKey);
                this.updateKey(resourceModel, newEffectiveKey, disabledResourceByKey);
                resourceModel.setDeprecatedKey(oldEffectiveKey);
                this.logger.info(COMPONENT_CHANGED_TO, (Object)oldEffectiveKey, (Object)newEffectiveKey);
                continue;
            }
            this.logger.warn(UNABLE_TO_UPDATE_COMPONENT_NO_MATCH_WAS_FOUND, (Object)oldEffectiveKey);
        }
    }

    private List<ResourceModel> loadEnabledResources(int moduleId, StringBuilder hql) {
        return this.session.createQuery(hql.toString()).setParameter("rootId", (Object)moduleId).setParameter("enabled", (Object)true).getResultList();
    }

    private Map<String, ResourceModel> loadDisabledResources(int moduleId, StringBuilder hql) {
        List disabledResources = this.session.createQuery(hql.toString()).setParameter("rootId", (Object)moduleId).setParameter("enabled", (Object)false).getResultList();
        HashMap<String, ResourceModel> disabledResourceByKey = new HashMap<String, ResourceModel>();
        for (ResourceModel disabledResourceModel : disabledResources) {
            disabledResourceByKey.put(disabledResourceModel.getKey(), disabledResourceModel);
        }
        return disabledResourceByKey;
    }

    private String getParentKey(InputFile matchedFile) {
        String filePath = PathUtils.sanitize((String)matchedFile.relativePath());
        String parentFolderPath = filePath.contains("/") ? StringUtils.substringBeforeLast((String)filePath, (String)"/") : "/";
        return parentFolderPath;
    }
}

