/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.database.model.MeasureMapper;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.technicaldebt.batch.Characteristic;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.ResourceCache;
import org.sonar.batch.index.ScanPersister;
import org.sonar.batch.index.SnapshotCache;
import org.sonar.batch.scan.measure.MeasureCache;
import org.sonar.core.persistence.DbSession;
import org.sonar.core.persistence.MyBatis;

public final class MeasurePersister
implements ScanPersister {
    private final MyBatis mybatis;
    private final RuleFinder ruleFinder;
    private final MeasureCache measureCache;
    private final SnapshotCache snapshotCache;
    private final ResourceCache resourceCache;

    public MeasurePersister(MyBatis mybatis, RuleFinder ruleFinder, MeasureCache measureCache, SnapshotCache snapshotCache, ResourceCache resourceCache) {
        this.mybatis = mybatis;
        this.ruleFinder = ruleFinder;
        this.measureCache = measureCache;
        this.snapshotCache = snapshotCache;
        this.resourceCache = resourceCache;
    }

    @Override
    public void persist() {
        DbSession session = this.mybatis.openSession(true);
        try {
            MeasureMapper mapper = (MeasureMapper)session.getMapper(MeasureMapper.class);
            for (Cache.Entry<Measure> entry : this.measureCache.entries()) {
                String effectiveKey = entry.key()[0].toString();
                Measure measure = entry.value();
                Resource resource = this.resourceCache.get(effectiveKey);
                if (!MeasurePersister.shouldPersistMeasure(resource, measure)) continue;
                Snapshot snapshot = this.snapshotCache.get(effectiveKey);
                MeasureModel measureModel = MeasurePersister.model(measure, this.ruleFinder).setSnapshotId(snapshot.getId());
                mapper.insert(measureModel);
            }
            session.commit();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save some measures", e);
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
    }

    @VisibleForTesting
    static boolean shouldPersistMeasure(@Nullable Resource resource, @Nullable Measure measure) {
        if (resource == null || measure == null) {
            return false;
        }
        return measure.getPersistenceMode().useDatabase() && (!ResourceUtils.isEntity((Resource)resource) || !measure.isBestValue()) && MeasurePersister.isMeasureNotEmpty(measure);
    }

    private static boolean isMeasureNotEmpty(Measure measure) {
        boolean isNotEmpty = false;
        for (int i = 1; i <= 5; ++i) {
            isNotEmpty = isNotEmpty || measure.getVariation(i) != null;
        }
        return measure.getValue() != null || measure.getData() != null || isNotEmpty;
    }

    static MeasureModel model(Measure measure, RuleFinder ruleFinder) {
        MeasureModel model = new MeasureModel();
        model.setMetricId(measure.getMetric().getId());
        model.setDescription(measure.getDescription());
        model.setData(measure.getData());
        model.setAlertStatus(measure.getAlertStatus());
        model.setAlertText(measure.getAlertText());
        model.setTendency(measure.getTendency());
        model.setVariationValue1(measure.getVariation1());
        model.setVariationValue2(measure.getVariation2());
        model.setVariationValue3(measure.getVariation3());
        model.setVariationValue4(measure.getVariation4());
        model.setVariationValue5(measure.getVariation5());
        model.setUrl(measure.getUrl());
        Characteristic characteristic = measure.getCharacteristic();
        if (characteristic != null) {
            model.setCharacteristicId(characteristic.id());
        }
        model.setPersonId(measure.getPersonId());
        model.setValue(measure.getValue());
        if (measure instanceof RuleMeasure) {
            RuleMeasure ruleMeasure = (RuleMeasure)measure;
            model.setRulePriority(ruleMeasure.getSeverity());
            RuleKey ruleKey = ruleMeasure.ruleKey();
            if (ruleKey != null) {
                Rule ruleWithId = ruleFinder.findByKey(ruleKey);
                if (ruleWithId == null) {
                    throw new IllegalStateException("Can not save a measure with unknown rule " + ruleMeasure);
                }
                model.setRuleId(ruleWithId.getId());
            }
        }
        return model;
    }
}

