/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.batch.sensor.duplication.DuplicationGroup;
import org.sonar.api.database.model.MeasureMapper;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.RuleFinder;
import org.sonar.batch.duplication.DuplicationCache;
import org.sonar.batch.duplication.DuplicationUtils;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.ResourceCache;
import org.sonar.batch.index.ScanPersister;
import org.sonar.batch.index.SnapshotCache;
import org.sonar.core.persistence.DbSession;
import org.sonar.core.persistence.MyBatis;

public final class DuplicationPersister
implements ScanPersister {
    private final MyBatis mybatis;
    private final RuleFinder ruleFinder;
    private final SnapshotCache snapshotCache;
    private final ResourceCache resourceCache;
    private final DuplicationCache duplicationCache;
    private final MetricFinder metricFinder;

    public DuplicationPersister(MyBatis mybatis, RuleFinder ruleFinder, SnapshotCache snapshotCache, ResourceCache resourceCache, DuplicationCache duplicationCache, MetricFinder metricFinder) {
        this.mybatis = mybatis;
        this.ruleFinder = ruleFinder;
        this.snapshotCache = snapshotCache;
        this.resourceCache = resourceCache;
        this.duplicationCache = duplicationCache;
        this.metricFinder = metricFinder;
    }

    @Override
    public void persist() {
        DbSession session = this.mybatis.openSession(false);
        try {
            MeasureMapper mapper = (MeasureMapper)session.getMapper(MeasureMapper.class);
            Metric duplicationMetricWithId = this.metricFinder.findByKey("duplications_data");
            for (Cache.Entry<List<DuplicationGroup>> entry : this.duplicationCache.entries()) {
                String effectiveKey = entry.key()[0].toString();
                Measure measure = new Measure(duplicationMetricWithId, DuplicationUtils.toXml((Iterable<DuplicationGroup>)entry.value())).setPersistenceMode(PersistenceMode.DATABASE);
                Resource resource = this.resourceCache.get(effectiveKey);
                if (!MeasurePersister.shouldPersistMeasure(resource, measure)) continue;
                Snapshot snapshot = this.snapshotCache.get(effectiveKey);
                MeasureModel measureModel = MeasurePersister.model(measure, this.ruleFinder).setSnapshotId(snapshot.getId());
                mapper.insert(measureModel);
            }
            session.commit();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save some measures", e);
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
    }
}

