/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.resources.Scopes;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.SonarException;
import org.sonar.api.violations.ViolationQuery;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.index.Bucket;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.index.ResourceKeyMigration;
import org.sonar.batch.issue.DeprecatedViolations;
import org.sonar.batch.issue.ModuleIssues;
import org.sonar.batch.scan.measure.MeasureCache;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.component.ScanGraph;

public class DefaultIndex
extends SonarIndex {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndex.class);
    private PersistenceManager persistence;
    private MetricFinder metricFinder;
    private final ScanGraph graph;
    private Project currentProject;
    private Map<Resource, Bucket> buckets = Maps.newHashMap();
    private Map<String, Bucket> bucketsByDeprecatedKey = Maps.newHashMap();
    private Set<Dependency> dependencies = Sets.newHashSet();
    private Map<Resource, Map<Resource, Dependency>> outgoingDependenciesByResource = Maps.newHashMap();
    private Map<Resource, Map<Resource, Dependency>> incomingDependenciesByResource = Maps.newHashMap();
    private ProjectTree projectTree;
    private final DeprecatedViolations deprecatedViolations;
    private ModuleIssues moduleIssues;
    private final MeasureCache measureCache;
    private ResourceKeyMigration migration;

    public DefaultIndex(PersistenceManager persistence, ProjectTree projectTree, MetricFinder metricFinder, ScanGraph graph, DeprecatedViolations deprecatedViolations, ResourceKeyMigration migration, MeasureCache measureCache) {
        this.persistence = persistence;
        this.projectTree = projectTree;
        this.metricFinder = metricFinder;
        this.graph = graph;
        this.deprecatedViolations = deprecatedViolations;
        this.migration = migration;
        this.measureCache = measureCache;
    }

    public void start() {
        Project rootProject = this.projectTree.getRootProject();
        if (StringUtils.isNotBlank((String)rootProject.getKey())) {
            this.doStart(rootProject);
        }
    }

    void doStart(Project rootProject) {
        Bucket bucket = new Bucket((Resource)rootProject);
        this.addBucket((Resource)rootProject, bucket);
        this.migration.checkIfMigrationNeeded(rootProject);
        this.persistence.saveProject(rootProject, null);
        this.currentProject = rootProject;
        for (Project module : rootProject.getModules()) {
            this.addModule(rootProject, module);
        }
    }

    private void addBucket(Resource resource, Bucket bucket) {
        this.buckets.put(resource, bucket);
        if (StringUtils.isNotBlank((String)resource.getDeprecatedKey())) {
            this.bucketsByDeprecatedKey.put(resource.getDeprecatedKey(), bucket);
        }
    }

    private void addModule(Project parent, Project module) {
        ProjectDefinition parentDefinition = this.projectTree.getProjectDefinition(parent);
        File parentBaseDir = parentDefinition.getBaseDir();
        ProjectDefinition moduleDefinition = this.projectTree.getProjectDefinition(module);
        File moduleBaseDir = moduleDefinition.getBaseDir();
        module.setPath(new PathResolver().relativePath(parentBaseDir, moduleBaseDir));
        this.addResource((Resource)module);
        for (Project submodule : module.getModules()) {
            this.addModule(module, submodule);
        }
    }

    public Project getProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project project, ModuleIssues moduleIssues) {
        this.currentProject = project;
        this.moduleIssues = moduleIssues;
    }

    public void clear() {
        Iterator<Map.Entry<Resource, Bucket>> it = this.buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Resource, Bucket> entry = it.next();
            Resource resource = entry.getKey();
            if (ResourceUtils.isSet((Resource)resource)) continue;
            entry.getValue().clear();
            it.remove();
        }
        Set<Dependency> projectDependencies = this.getDependenciesBetweenProjects();
        this.dependencies.clear();
        this.incomingDependenciesByResource.clear();
        this.outgoingDependenciesByResource.clear();
        for (Dependency projectDependency : projectDependencies) {
            projectDependency.setId(null);
            this.registerDependency(projectDependency);
        }
    }

    @CheckForNull
    public Measure getMeasure(Resource resource, Metric<?> metric) {
        return (Measure)this.getMeasures(resource, MeasuresFilters.metric(metric));
    }

    @CheckForNull
    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        Resource indexedResource = this.getResource(resource);
        if (indexedResource == null) {
            return null;
        }
        Iterable<Measure> unfiltered = filter instanceof MeasuresFilters.MetricFilter ? this.measureCache.byMetric(indexedResource, ((MeasuresFilters.MetricFilter)filter).filterOnMetricKey()) : this.measureCache.byResource(indexedResource);
        ArrayList<Measure> all = new ArrayList<Measure>();
        if (unfiltered != null) {
            for (Measure measure : unfiltered) {
                all.add(measure);
            }
        }
        return (M)filter.filter(all);
    }

    public Measure addMeasure(Resource resource, Measure measure) {
        Bucket bucket = this.getBucket(resource);
        if (bucket != null) {
            org.sonar.api.measures.Metric metric = this.metricFinder.findByKey(measure.getMetricKey());
            if (metric == null) {
                throw new SonarException("Unknown metric: " + measure.getMetricKey());
            }
            measure.setMetric(metric);
            if (this.measureCache.contains(resource, measure) && !measure.getMetric().equals((Object)CoreMetrics.TESTS)) {
                throw new SonarException("Can not add the same measure twice on " + resource + ": " + measure);
            }
            this.measureCache.put(resource, measure);
        }
        return measure;
    }

    public Dependency addDependency(Dependency dependency) {
        Dependency existingDep = this.getEdge(dependency.getFrom(), dependency.getTo());
        if (existingDep != null) {
            return existingDep;
        }
        Dependency parentDependency = dependency.getParent();
        if (parentDependency != null) {
            this.addDependency(parentDependency);
        }
        if (this.registerDependency(dependency)) {
            this.persistence.saveDependency(this.currentProject, dependency, parentDependency);
        }
        return dependency;
    }

    boolean registerDependency(Dependency dependency) {
        Bucket fromBucket = this.doIndex(dependency.getFrom());
        Bucket toBucket = this.doIndex(dependency.getTo());
        if (fromBucket != null && toBucket != null) {
            this.dependencies.add(dependency);
            this.registerOutgoingDependency(dependency);
            this.registerIncomingDependency(dependency);
            return true;
        }
        return false;
    }

    private void registerOutgoingDependency(Dependency dependency) {
        Map<Resource, Dependency> outgoingDeps = this.outgoingDependenciesByResource.get(dependency.getFrom());
        if (outgoingDeps == null) {
            outgoingDeps = new HashMap<Resource, Dependency>();
            this.outgoingDependenciesByResource.put(dependency.getFrom(), outgoingDeps);
        }
        outgoingDeps.put(dependency.getTo(), dependency);
    }

    private void registerIncomingDependency(Dependency dependency) {
        Map<Resource, Dependency> incomingDeps = this.incomingDependenciesByResource.get(dependency.getTo());
        if (incomingDeps == null) {
            incomingDeps = new HashMap<Resource, Dependency>();
            this.incomingDependenciesByResource.put(dependency.getTo(), incomingDeps);
        }
        incomingDeps.put(dependency.getFrom(), dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Dependency getEdge(Resource from, Resource to) {
        Map<Resource, Dependency> map = this.outgoingDependenciesByResource.get(from);
        if (map != null) {
            return map.get(to);
        }
        return null;
    }

    public boolean hasEdge(Resource from, Resource to) {
        return this.getEdge(from, to) != null;
    }

    public Set<Resource> getVertices() {
        return this.buckets.keySet();
    }

    public Collection<Dependency> getOutgoingEdges(Resource from) {
        Map<Resource, Dependency> deps = this.outgoingDependenciesByResource.get(from);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    public Collection<Dependency> getIncomingEdges(Resource to) {
        Map<Resource, Dependency> deps = this.incomingDependenciesByResource.get(to);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    Set<Dependency> getDependenciesBetweenProjects() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Dependency dependency : this.dependencies) {
            if (!ResourceUtils.isSet((Resource)dependency.getFrom()) && !ResourceUtils.isSet((Resource)dependency.getTo())) continue;
            result.add(dependency);
        }
        return result;
    }

    public List<Violation> getViolations(ViolationQuery violationQuery) {
        Resource resource = violationQuery.getResource();
        if (resource == null) {
            throw new IllegalArgumentException("A resource must be set on the ViolationQuery in order to search for violations.");
        }
        if (!Scopes.isHigherThanOrEquals((Resource)resource, (String)"FIL")) {
            return Collections.emptyList();
        }
        Bucket bucket = this.buckets.get(resource);
        if (bucket == null) {
            return Collections.emptyList();
        }
        List<Violation> violations = this.deprecatedViolations.get(bucket.getResource().getEffectiveKey());
        if (violationQuery.getSwitchMode() == ViolationQuery.SwitchMode.BOTH) {
            return violations;
        }
        ArrayList filteredViolations = Lists.newArrayList();
        for (Violation violation : violations) {
            if (!DefaultIndex.isFiltered(violation, violationQuery.getSwitchMode())) continue;
            filteredViolations.add(violation);
        }
        return filteredViolations;
    }

    private static boolean isFiltered(Violation violation, ViolationQuery.SwitchMode mode) {
        return mode == ViolationQuery.SwitchMode.BOTH || DefaultIndex.isSwitchOff(violation, mode) || DefaultIndex.isSwitchOn(violation, mode);
    }

    private static boolean isSwitchOff(Violation violation, ViolationQuery.SwitchMode mode) {
        return mode == ViolationQuery.SwitchMode.OFF && violation.isSwitchedOff();
    }

    private static boolean isSwitchOn(Violation violation, ViolationQuery.SwitchMode mode) {
        return mode == ViolationQuery.SwitchMode.ON && !violation.isSwitchedOff();
    }

    public void addViolation(Violation violation, boolean force) {
        Resource resource = violation.getResource();
        if (resource == null) {
            violation.setResource((Resource)this.currentProject);
        } else if (!Scopes.isHigherThanOrEquals((Resource)resource, (String)"FIL")) {
            throw new IllegalArgumentException("Violations are only supported on files, directories and project");
        }
        Rule rule = violation.getRule();
        if (rule == null) {
            LOG.warn("Rule is null. Ignoring violation {}", (Object)violation);
            return;
        }
        Bucket bucket = this.getBucket(resource);
        if (bucket == null) {
            LOG.warn("Resource is not indexed. Ignoring violation {}", (Object)violation);
            return;
        }
        violation.setSeverity(null);
        violation.setResource(bucket.getResource());
        this.moduleIssues.initAndAddViolation(violation);
    }

    public void addLink(ProjectLink link) {
        this.persistence.saveLink(this.currentProject, link);
    }

    public void deleteLink(String key) {
        this.persistence.deleteLink(this.currentProject, key);
    }

    public List<Event> getEvents(Resource resource) {
        return this.persistence.getEvents(resource);
    }

    public void deleteEvent(Event event) {
        this.persistence.deleteEvent(event);
    }

    public Event addEvent(Resource resource, String name, String description, String category, Date date) {
        Event event = new Event(name, description, category);
        event.setDate(date);
        event.setCreatedAt(new Date());
        this.persistence.saveEvent(resource, event);
        return null;
    }

    public void setSource(Resource reference, String source) {
        Bucket bucket = this.getBucket(reference);
        if (bucket != null) {
            this.persistence.setSource(reference, source);
        }
    }

    public String getSource(Resource resource) {
        return this.persistence.getSource(resource);
    }

    public Resource addResource(Resource resource) {
        Bucket bucket = this.doIndex(resource);
        return bucket != null ? bucket.getResource() : null;
    }

    @CheckForNull
    public <R extends Resource> R getResource(@Nullable R reference) {
        Bucket bucket = this.getBucket(reference);
        if (bucket != null) {
            return (R)bucket.getResource();
        }
        return null;
    }

    public List<Resource> getChildren(Resource resource) {
        LinkedList children = Lists.newLinkedList();
        Bucket bucket = this.getBucket(resource);
        if (bucket != null) {
            for (Bucket childBucket : bucket.getChildren()) {
                children.add(childBucket.getResource());
            }
        }
        return children;
    }

    public Resource getParent(Resource resource) {
        Bucket bucket = this.getBucket(resource);
        if (bucket != null && bucket.getParent() != null) {
            return bucket.getParent().getResource();
        }
        return null;
    }

    public boolean index(Resource resource) {
        Bucket bucket = this.doIndex(resource);
        return bucket != null;
    }

    private Bucket doIndex(Resource resource) {
        if (resource.getParent() != null) {
            this.doIndex(resource.getParent());
        }
        return this.doIndex(resource, resource.getParent());
    }

    public boolean index(Resource resource, Resource parentReference) {
        Bucket bucket = this.doIndex(resource, parentReference);
        return bucket != null;
    }

    private Bucket doIndex(Resource resource, Resource parentReference) {
        Bucket parentBucket;
        Bucket bucket = this.getBucket(resource);
        if (bucket != null) {
            return bucket;
        }
        if (StringUtils.isBlank((String)resource.getKey())) {
            LOG.warn("Unable to index a resource without key " + resource);
            return null;
        }
        Resource parent = null;
        if (!ResourceUtils.isLibrary((Resource)resource)) {
            parent = (Resource)ObjectUtils.defaultIfNull((Object)parentReference, (Object)this.currentProject);
        }
        if ((parentBucket = this.getBucket(parent)) == null && parent != null) {
            LOG.warn("Resource ignored, parent is not indexed: " + resource);
            return null;
        }
        resource.setEffectiveKey(ComponentKeys.createEffectiveKey((Project)this.currentProject, (Resource)resource));
        bucket = new Bucket(resource).setParent(parentBucket);
        this.addBucket(resource, bucket);
        Resource parentSnapshot = parentBucket != null ? parentBucket.getResource() : null;
        Snapshot snapshot = this.persistence.saveResource(this.currentProject, resource, parentSnapshot);
        if (ResourceUtils.isPersistable((Resource)resource) && !"LIB".equals(resource.getQualifier())) {
            this.graph.addComponent(resource, snapshot);
        }
        return bucket;
    }

    public boolean isExcluded(@Nullable Resource reference) {
        return false;
    }

    public boolean isIndexed(@Nullable Resource reference, boolean acceptExcluded) {
        return this.getBucket(reference) != null;
    }

    private Bucket getBucket(@Nullable Resource reference) {
        Bucket bucket;
        if (reference == null) {
            return null;
        }
        if (StringUtils.isNotBlank((String)reference.getKey())) {
            return this.buckets.get(reference);
        }
        if (StringUtils.isNotBlank((String)reference.getDeprecatedKey()) && (bucket = this.bucketsByDeprecatedKey.get(reference.getDeprecatedKey())) != null) {
            reference.setKey(bucket.getResource().getKey());
            reference.setPath(bucket.getResource().getPath());
            LOG.debug("Resource {} was found using deprecated key. Please update your plugin.", (Object)reference);
            return bucket;
        }
        return null;
    }
}

