/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.index.Data;
import org.sonar.batch.index.ScanPersister;
import org.sonar.batch.index.SnapshotCache;
import org.sonar.core.persistence.DbSession;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.source.db.SnapshotDataDao;
import org.sonar.core.source.db.SnapshotDataDto;

public class ComponentDataPersister
implements ScanPersister {
    private final ComponentDataCache data;
    private final SnapshotCache snapshots;
    private final SnapshotDataDao dao;
    private final MyBatis mybatis;

    public ComponentDataPersister(ComponentDataCache data, SnapshotCache snapshots, SnapshotDataDao dao, MyBatis mybatis) {
        this.data = data;
        this.snapshots = snapshots;
        this.dao = dao;
        this.mybatis = mybatis;
    }

    @Override
    public void persist() {
        DbSession session = this.mybatis.openSession(true);
        for (Map.Entry<String, Snapshot> componentEntry : this.snapshots.snapshots()) {
            String componentKey = componentEntry.getKey();
            Snapshot snapshot = componentEntry.getValue();
            for (Cache.Entry dataEntry : this.data.entries(componentKey)) {
                Data value = (Data)dataEntry.value();
                if (value == null) continue;
                SnapshotDataDto dto = new SnapshotDataDto();
                dto.setSnapshotId((long)snapshot.getId().intValue());
                dto.setResourceId((long)snapshot.getResourceId().intValue());
                dto.setDataType(dataEntry.key()[1].toString());
                dto.setData(value.writeString());
                this.dao.insert((SqlSession)session, dto);
            }
        }
        session.commit();
    }
}

