/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import javax.annotation.CheckForNull;
import org.sonar.api.BatchComponent;
import org.sonar.batch.highlighting.SyntaxHighlightingData;
import org.sonar.batch.highlighting.SyntaxHighlightingDataValueCoder;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;
import org.sonar.batch.index.Data;
import org.sonar.batch.index.StringData;

public class ComponentDataCache
implements BatchComponent {
    private final Cache cache;

    public ComponentDataCache(Caches caches) {
        caches.registerValueCoder(SyntaxHighlightingData.class, new SyntaxHighlightingDataValueCoder());
        this.cache = caches.createCache("componentData");
    }

    public <D extends Data> ComponentDataCache setData(String componentKey, String dataType, D data) {
        this.cache.put(componentKey, dataType, data);
        return this;
    }

    public ComponentDataCache setStringData(String componentKey, String dataType, String data) {
        return this.setData(componentKey, dataType, new StringData(data));
    }

    @CheckForNull
    public <D extends Data> D getData(String componentKey, String dataType) {
        return (D)((Data)this.cache.get(componentKey, dataType));
    }

    @CheckForNull
    public String getStringData(String componentKey, String dataType) {
        Data data = (Data)this.cache.get(componentKey, dataType);
        return data == null ? null : ((StringData)data).data();
    }

    public <D extends Data> Iterable<Cache.Entry<D>> entries(String componentKey) {
        return this.cache.entries(componentKey);
    }
}

