/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.highlighting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.batch.highlighting.SyntaxHighlightingData;
import org.sonar.batch.highlighting.SyntaxHighlightingRule;

public class SyntaxHighlightingDataBuilder {
    private Set<SyntaxHighlightingRule> syntaxHighlightingRuleSet = Sets.newTreeSet((Comparator)new Ordering<SyntaxHighlightingRule>(){

        public int compare(@Nullable SyntaxHighlightingRule left, @Nullable SyntaxHighlightingRule right) {
            int result = left.getStartPosition() - right.getStartPosition();
            if (result == 0) {
                result = left.getEndPosition() - right.getEndPosition();
            }
            return result;
        }
    });

    @VisibleForTesting
    public Set<SyntaxHighlightingRule> getSyntaxHighlightingRuleSet() {
        return this.syntaxHighlightingRuleSet;
    }

    public SyntaxHighlightingDataBuilder registerHighlightingRule(int startOffset, int endOffset, TypeOfText typeOfText) {
        SyntaxHighlightingRule syntaxHighlightingRule = SyntaxHighlightingRule.create(startOffset, endOffset, typeOfText);
        this.syntaxHighlightingRuleSet.add(syntaxHighlightingRule);
        return this;
    }

    public SyntaxHighlightingData build() {
        this.checkOverlappingBoudaries();
        return new SyntaxHighlightingData(this.syntaxHighlightingRuleSet);
    }

    private void checkOverlappingBoudaries() {
        if (this.syntaxHighlightingRuleSet.size() > 1) {
            Iterator<SyntaxHighlightingRule> it = this.syntaxHighlightingRuleSet.iterator();
            SyntaxHighlightingRule previous = it.next();
            while (it.hasNext()) {
                SyntaxHighlightingRule current = it.next();
                if (previous.getEndPosition() > current.getStartPosition() && previous.getEndPosition() < current.getEndPosition()) {
                    String errorMsg = String.format("Cannot register highlighting rule for characters from %s to %s as it overlaps at least one existing rule", current.getStartPosition(), current.getEndPosition());
                    throw new IllegalStateException(errorMsg);
                }
                previous = current;
            }
        }
    }
}

