/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.highlighting;

import com.google.common.base.Preconditions;
import org.sonar.api.batch.sensor.highlighting.HighlightingBuilder;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.batch.highlighting.SyntaxHighlightingDataBuilder;
import org.sonar.batch.index.ComponentDataCache;

public class DefaultHighlightingBuilder
implements HighlightingBuilder {
    private final SyntaxHighlightingDataBuilder builder;
    private String componentKey;
    private ComponentDataCache cache;
    private boolean done = false;

    public DefaultHighlightingBuilder(String componentKey, ComponentDataCache cache) {
        this.componentKey = componentKey;
        this.cache = cache;
        this.builder = new SyntaxHighlightingDataBuilder();
    }

    public HighlightingBuilder highlight(int startOffset, int endOffset, TypeOfText typeOfText) {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"done() already called");
        this.builder.registerHighlightingRule(startOffset, endOffset, typeOfText);
        return this;
    }

    public void done() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"done() already called");
        this.cache.setData(this.componentKey, "highlight_syntax", this.builder.build());
    }
}

