/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.duplication;

import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.ValueCoder;
import java.util.ArrayList;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.block.FileBlocks;

class FileBlocksValueCoder
implements ValueCoder {
    FileBlocksValueCoder() {
    }

    public void put(Value value, Object object, CoderContext context) {
        FileBlocks blocks = (FileBlocks)object;
        value.putUTF(blocks.resourceId());
        value.put(blocks.blocks().size());
        for (Block b : blocks.blocks()) {
            value.putByteArray(b.getBlockHash().getBytes());
            value.put(b.getIndexInFile());
            value.put(b.getStartLine());
            value.put(b.getEndLine());
            value.put(b.getStartUnit());
            value.put(b.getEndUnit());
        }
    }

    public Object get(Value value, Class clazz, CoderContext context) {
        String resourceId = value.getString();
        int count = value.getInt();
        ArrayList<Block> blocks = new ArrayList<Block>(count);
        for (int i = 0; i < count; ++i) {
            Block.Builder b = Block.builder();
            b.setResourceId(resourceId);
            b.setBlockHash(new ByteArray(value.getByteArray()));
            b.setIndexInFile(value.getInt());
            int startLine = value.getInt();
            int endLine = value.getInt();
            b.setLines(startLine, endLine);
            int startUnit = value.getInt();
            int endUnit = value.getInt();
            b.setUnit(startUnit, endUnit);
            blocks.add(b.build());
        }
        return new FileBlocks(resourceId, blocks);
    }
}

