/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.duplication;

import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.api.batch.sensor.duplication.DuplicationGroup;

public class DuplicationUtils {
    public static String toXml(Iterable<DuplicationGroup> duplications) {
        StringBuilder xml = new StringBuilder();
        xml.append("<duplications>");
        for (DuplicationGroup duplication : duplications) {
            xml.append("<g>");
            DuplicationUtils.toXml(xml, duplication.originBlock());
            for (DuplicationGroup.Block part : duplication.duplicates()) {
                DuplicationUtils.toXml(xml, part);
            }
            xml.append("</g>");
        }
        xml.append("</duplications>");
        return xml.toString();
    }

    private static void toXml(StringBuilder xml, DuplicationGroup.Block part) {
        xml.append("<b s=\"").append(part.startLine()).append("\" l=\"").append(part.length()).append("\" r=\"").append(StringEscapeUtils.escapeXml((String)part.resourceKey())).append("\"/>");
    }
}

